//	Advanced System UI
//	Copyright (c) 2010-2011 Brand Huntsman <brand.huntsman@gmail.com>

#include "main.h"
#include "draw.h"
#include "hardware.h"
#include "dialog.h"
#include "dsme.h"
 #include "flashlight.h"

//////////////////////////////////////////////////////////////////////////

static unsigned flashlight_original_brightness;

void draw_flashlight( unsigned force ){
	if(force){
		// solid white background
		XSetForeground(window.display, window.gc, WhitePixel(window.display, window.screen));
		x_fill_rectangle(0, 0, window.width, window.height);
		x_flush();
	}
}

// no click handler

static void keypress_flashlight( ){
	if(keypress.type != KEY_SHORT) return;

	switch(keypress.keycode){
	case KEYCODE_ESCAPE:
	case KEYCODE_FULLSCREEN:
		// close flashlight
		highlight_selected_area(0, 0, window.width, window.height); // hack
		dialog_close();
		break;
	default:
		// ignore all other keys
		break;
	}
}

static void reset_flashlight( ){
	// restore original brightness level
	hw_set_brightness(flashlight_original_brightness, 0);
	// allow screen to blank
	dsme_allow_blanking();
}

//////////////////////////////////////////////////////////////////////////

void flashlight_open( ){
	dialog_reset(); // close any open dialogs

	highlight_selected_area(0, 0, window.width, window.height); // hack

	dialog_open(draw_flashlight, NULL, keypress_flashlight, reset_flashlight, DLG_REDRAW_OFF); // no clicks or redraw

	// prevent screen from blanking
	dsme_pause_blanking();

	// save original brightness level
	flashlight_original_brightness = hw_screen.brightness_level;
	// set full brightness
	hw_set_brightness(hw_screen.brightness_max, 0);
}
