//	Advanced System UI
//	Copyright (c) 2010-2011 Brand Huntsman <brand.huntsman@gmail.com>

#define MAX_FONT_SIZE 150

#include <Xft.h>

#include "window.h"
#include "main.h"
 #include "text.h"

//////////////////////////////////////////////////////////////////////////

static XftFont *fonts[MAX_FONT_SIZE];

void text_init( ){
	int f;

	for(f = 0; f < MAX_FONT_SIZE; f++)
		fonts[f] = NULL;
}

void text_free_fonts( ){
	int f;

	for(f = 0; f < MAX_FONT_SIZE; f++)
		if(fonts[f]) XftFontClose(window.display, fonts[f]);
}

int draw_text( char *string, unsigned size, XColor *color, int x, int y, e_xalign xalign, e_yalign yalign, unsigned max_width ){
	int length = strlen(string), ox = x, oy = y;
	unsigned width, clip;
	XftFont *font;
	XGlyphInfo info;

	// get font
	if(size == 0 || size > MAX_FONT_SIZE){
		error_write("font size must be 1 to %d pixels", MAX_FONT_SIZE);
		return 0;
	}
	size--;
	if(fonts[size] == NULL)
		fonts[size] = XftFontOpen(window.display, window.screen, XFT_FAMILY, XftTypeString, "sans", XFT_WEIGHT, XftTypeInteger, XFT_WEIGHT_MEDIUM, XFT_PIXEL_SIZE, XftTypeInteger, size+1, 0);
	font = fonts[size];
	XftTextExtentsUtf8(window.display, font, (const FcChar8 *)string, length, &info);

	// clip width
	clip = (max_width && info.width > max_width ? 1 : 0);
	width = (clip ? max_width : info.width);

	// alignment
	switch(xalign){
	case ALIGN_LEFT: x += info.x; break;
	case ALIGN_CENTER: x -= (width>>1) - info.x; break;
	case ALIGN_RIGHT: x -= width - info.x; break;
	}
	switch(yalign){
	case ALIGN_TOP: y += info.y; break;
	case ALIGN_MIDDLE: y += (info.height>>1) - (info.height - info.y); break;
	case ALIGN_BASELINE: /* do nothing */ break;
	case ALIGN_BOTTOM: y -= (info.height - info.y); break;
	}
	// info.y is the distance from top to baseline

	// draw the string
	{
		XftDraw *surface;
		XftColor xft_color;
		Region region = 0;

		xft_color.pixel = color->pixel;
		xft_color.color.red = color->red;
		xft_color.color.green = color->green;
		xft_color.color.blue = color->blue;
		xft_color.color.alpha = 0xffff;
		surface = XftDrawCreate(window.display, window.window, window.visual, window.colormap);
		if(clip){
			int cx = 0, cy = 0; // upper left corner
			switch(xalign){
			case ALIGN_LEFT: cx = ox; break;
			case ALIGN_CENTER: cx = ox - (width>>1); break;
			case ALIGN_RIGHT: cx = ox - width; break;
			}
			switch(yalign){
			case ALIGN_TOP: cy = oy; break;
			case ALIGN_MIDDLE: cy = oy - (info.height>>1); break;
			case ALIGN_BASELINE: cy = oy - info.y; break;
			case ALIGN_BOTTOM: cy = oy - info.height; break;
			}
			XPoint points[] = {{cx,cy}, {cx,cy+info.height}, {cx+width,cy+info.height}, {cx+width,cy}};
			region = XPolygonRegion(points, 4, WindingRule); // EvenOddRule or WindingRule
			XftDrawSetClip(surface, region);
		}
		XftDrawStringUtf8(surface, &xft_color, font, x, y, (const FcChar8 *)string, length);
		XftDrawDestroy(surface);
		if(clip) XDestroyRegion(region);
	}

	return width;
}
