//	Advanced System UI
//	Copyright (c) 2011 Brand Huntsman <brand.huntsman@gmail.com>

#include "main.h"
#include "clock.h"

//////////////////////////////////////////////////////////////////////////

static GtkWidget *clock_ampm, *popup_noasui, *popup_onmap, *popup_fullscreen, *popup_cooldown;

static void toggle_checkbox_clock_24h( GtkToggleButton *widget, gpointer data ){
	unsigned state = (gtk_toggle_button_get_active(widget) == TRUE ? 1 : 0);
	conf_set_bool((const char *)data, state);
	gtk_widget_set_sensitive(clock_ampm, (state ? FALSE : TRUE));
}

static void change_popup_duration( GObject *gobject, GParamSpec *arg1, gpointer user_data ){
	if(strcmp(arg1->name, "value")) return;
	int value;
	g_object_get(gobject, "value", &value, NULL);
	if(value >= 0){
		conf_set_int((const char *)user_data, value);
		unsigned state = (value > 0 ? TRUE : FALSE);
		gtk_widget_set_sensitive(popup_noasui, state);
		gtk_widget_set_sensitive(popup_onmap, (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(popup_noasui)) ? FALSE : state));
		gtk_widget_set_sensitive(popup_fullscreen, state);
		gtk_widget_set_sensitive(popup_cooldown, state);
	}
}

static void toggle_checkbox_popup_noasui( GtkToggleButton *widget, gpointer data ){
	unsigned state = (gtk_toggle_button_get_active(widget) == TRUE ? 1 : 0);
	conf_set_bool((const char *)data, state);
	gtk_widget_set_sensitive(popup_onmap, (state ? FALSE : TRUE));
}

static void change_popup_cooldown( GObject *gobject, GParamSpec *arg1, gpointer user_data ){
	if(strcmp(arg1->name, "value")) return;
	int value;
	g_object_get(gobject, "value", &value, NULL);
	if(value >= 60 && value <= 3600) conf_set_int((const char *)user_data, value);
}

//////////////////////////////////////////////////////////////////////////

void clock_click_callback( GtkWidget *widget, gpointer data ){
	new_section_vbox("Clock"); // add setting widgets to section_content_box

	GtkWidget *clock_24h = new_checkbox(conf_clock_24h, "display 24 hour clock (else 12 hour)", toggle_checkbox_clock_24h);

	new_separator();

	clock_ampm = new_checkbox(conf_clock_ampm, "display AM/PM indicator [12 hour clock only]", NULL);
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(clock_24h)))
		gtk_widget_set_sensitive(clock_ampm, FALSE); // disable when 24h clock

	new_separator();

	new_message("A popup with battery status and clock can be shown each time screen turns on. Setting duration to zero will disable the popup.");
	new_uint_value(conf_popup_duration, "popup duration (seconds)", 0, 15, change_popup_duration);

	popup_noasui = new_checkbox(conf_popup_noasui, "don't show popup when ASUI is visible", toggle_checkbox_popup_noasui);
	popup_onmap = new_checkbox(conf_popup_onmap, "show popup when mapping ASUI", NULL);
	popup_fullscreen = new_checkbox(conf_popup_fullscreen, "fullscreen popup", NULL);
	popup_cooldown = new_uint_value(conf_popup_cooldown, "minimum time before opening popup again (seconds)", 60, 3600, change_popup_cooldown);
	if(conf_get_int(conf_popup_duration) == 0){
		gtk_widget_set_sensitive(popup_noasui, FALSE); // disable when duration is zero
		gtk_widget_set_sensitive(popup_onmap, FALSE); // disable when duration is zero
		gtk_widget_set_sensitive(popup_fullscreen, FALSE); // disable when duration is zero
		gtk_widget_set_sensitive(popup_cooldown, FALSE); // disable when duration is zero
	} else if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(popup_noasui)))
		gtk_widget_set_sensitive(popup_onmap, FALSE); // disable when no-asui is checked

	new_separator();
}
