//	Advanced System UI
//	Copyright (c) 2010-2011 Brand Huntsman <brand.huntsman@gmail.com>

#include <stdio.h>

#include "window.h"
#include "main.h"
#include "draw.h"
#include "text.h"
#include "config.h"
#include "hardware.h"
 #include "widget_volume.h"

//////////////////////////////////////////////////////////////////////////

static int volume_widget_x, volume_widget_y;

void draw_volume_widget( unsigned force, int x, int y ){
	if(force){
		// background for all widgets is cleared by draw_window()
		volume_widget_page = primary_widgets;
		volume_widget_x = x;
		volume_widget_y = y;
	} else if(hw_changes & (HW_VOLUME|HW_VOLUME_OUTPUT)){
		x = volume_widget_x;
		y = volume_widget_y;
		// widget background
		x_set_color(bg_color);
		x_fill_rectangle(x, y, 399, 99);
	} else return;

	// slider
	draw_scrollbar(&im_volume, x, y, (hw_volume < 0 ? -hw_volume : hw_volume), 0, 100);
	draw_step_buttons(x, y, hw_volume > 0, hw_volume >= 0 && hw_volume < 100);
	// value
	{
		char value[4];
		snprintf(value, sizeof(value), "%d", (hw_volume < 0 ? -hw_volume : hw_volume));
		draw_text(value, 16, fg1_color, x+199, y+78, ALIGN_CENTER, ALIGN_MIDDLE, 0);
	}

	// mute button
	if(hw_volume < 0){
		// red slash if muted
		x_set_color(red_status_color);
		x_set_style(2, LineSolid); // 2 wide
		x_draw_line(x+184,y+78+9, x+214,y+78-9);
	}
	x_set_color(innerline_color);
	x_set_style(1, LineOnOffDash); // dotted line
	x_draw_line(x+159,y+55, x+239,y+55);
	x_draw_line(x+159,y+56, x+159,y+99);
	x_draw_line(x+239,y+56, x+239,y+99);
	x_reset_style();
	draw_tap_markers(x+160, y+56, 43, 1, 0); // short tap only (mute)

	// output device
	if(hw_sensors.headphones)
		draw_text("headphones", 16, white_color, x+380, y+84, ALIGN_RIGHT, ALIGN_BASELINE, 0);
	else if(hw_bluetooth.headset)
		draw_text("bluetooth", 16, red_status_color, x+380, y+84, ALIGN_RIGHT, ALIGN_BASELINE, 0);
	else
		draw_text("speakers", 16, fg2_color, x+380, y+84, ALIGN_RIGHT, ALIGN_BASELINE, 0);
}

//////////////////////////////////////////////////////////////////////////

void set_volume( int level ){
	#ifdef ARCH_armel
	conf_set_int(conf_volume, level);
	hw_volume = conf_get_int(conf_volume);
	#endif

	hw_changes |= HW_VOLUME; // force redraw
	draw_volume_widget(0, 0, 0);
	hw_changes &= ~HW_VOLUME; // unset flag
	x_flush();
}

static void decrement_volume( ){
	if(hw_volume > 0)
		set_volume(hw_volume-1);
	else
		button_callback = NULL;
}

static void increment_volume( ){
	if(hw_volume < 100)
		set_volume(hw_volume+1);
	else
		button_callback = NULL;
}

static void update_slider( ){
	if(click.y + click.offset_y <= 55){
		int position = click_scrollbar(click.x + click.offset_x, 0, 100);

		if(position != hw_volume)
			set_volume(position);
	}
}

static s_tap_throttler volume_throttle;

void click_volume_widget( ){
	if(click.y > 55){

		if(click.x < 50){

			// STEP DOWN BUTTON

			if(click.type == CLICK_DOWN){

				if(hw_volume > 0){
					button_autorepeat = 1;
					button_callback = decrement_volume;
				}

			} else if(click.type == CLICK_SHORT || click.type == CLICK_LONG || click.type == CLICK_DRAG){

				if(click.type == CLICK_SHORT)
					decrement_volume();

				button_callback = NULL;

			} // ignore motion and hold

		} else if(click.x < 100){

			// STEP UP BUTTON

			if(click.type == CLICK_DOWN){

				if(hw_volume >= 0 && hw_volume < 100){
					button_autorepeat = 1;
					button_callback = increment_volume;
				}

			} else if(click.type == CLICK_SHORT || click.type == CLICK_LONG || click.type == CLICK_DRAG){

				if(click.type == CLICK_SHORT && hw_volume >= 0)
					increment_volume();

				button_callback = NULL;

			} // ignore motion and hold

		} else if(click.x > 159 && click.x < 239){

			// MUTE BUTTON

			if(click.type != CLICK_SHORT) return; // no long press or drag support

			if(throttle_taps(&volume_throttle)) return;

			set_volume(-hw_volume);

			finalize_tap(volume_throttle);

		}

	} else if(hw_volume >= 0){

		// SLIDER

		if(click.type == CLICK_SHORT){

			// tap

			if(throttle_taps(&volume_throttle)) return;

			update_slider(click.x);

			finalize_tap(volume_throttle);

		} else if(click.type == CLICK_DOWN){

			update_slider(click.x);

		} else if((click.type == CLICK_MOTION || click.type == CLICK_DRAG) && click.y + click.offset_y <= 55){

			update_slider(click.x + click.offset_x);

		}
	}
}

////////////////////////////////////////////////////////////////////////// WIDGET

s_widget widget_volume = {"Volume", "/apps/asui_state/cell_volume", FULL_WIDGET, draw_volume_widget, click_volume_widget, 0};
