#include <gconf/gconf-client.h>

extern const char *conf_max_brightness;
extern const char *conf_brightness;
extern const char *conf_dim_timeout;
extern const char *conf_blank_timeout;
extern const char *conf_volume;
extern const char *conf_screen_autolock1;
extern const char *conf_screen_autolock2;
extern const char *conf_screen_stayslit1;
extern const char *conf_screen_stayslit2;

extern const char *conf_brightness_level;
extern const char *conf_theme;
extern const char *conf_ssh_server;

extern const char *conf_alarm_open;
extern const char *conf_alarm_tklock;
extern const char *conf_alarm_cb_service;
extern const char *conf_alarm_cb_path;
extern const char *conf_alarm_cb_iface;
extern const char *conf_alarm_cb_method;
extern const char *conf_alarm_description;
extern const char *conf_alarm_sound;
extern const char *conf_alarm_mode;
extern const char *conf_alarm_timestamp;

extern GConfClient *gconf_client;

// battery
extern unsigned cfg_battery_idle_time, cfg_memory_format, cfg_swap_format, cfg_temperature_F;
// clock
extern unsigned cfg_clock_24h, cfg_clock_ampm;
extern unsigned cfg_popup_duration, cfg_popup_onmap, cfg_popup_fullscreen, cfg_popup_cooldown, cfg_popup_noasui;
// brightness
extern unsigned cfg_brightness_enhanced, cfg_brightness_allow_zero;
// BRV keys
extern unsigned cfg_buttons_rotate, cfg_buttons_brightness, cfg_buttons_brightness_step, cfg_buttons_volume, cfg_buttons_volume_step;
// button modes
extern unsigned cfg_double_tap, cfg_lock_and_close, cfg_n800_lock_mode, cfg_rotate_and_close;
extern unsigned cfg_buttons_dpad_short, cfg_buttons_dpad_long, cfg_buttons_lock1_short, cfg_buttons_lock1_long, cfg_buttons_lock2_short, cfg_buttons_lock2_long;
extern unsigned cfg_secure_action, cfg_secure_power_action, cfg_secure_button;
extern unsigned cfg_power_unlock_key;
// user interface
extern unsigned cfg_service_size_unit, cfg_short_tap_markers, cfg_start_visible, cfg_threshold_black, cfg_threshold_white;
// alarm
extern unsigned cfg_alarm_duration, cfg_alarm_volume_min, cfg_alarm_volume_max, cfg_alarm_volume_step;

// state
extern unsigned cfg_theme, cfg_ssh_server;

#define CFG_BUTTONS_ZOOM 1
#define CFG_BUTTONS_UD 2
#define CFG_BUTTONS_LR 3

//////////////////////////////////////////////////////////////////////////

typedef enum e_widget_size { EMPTY_CELL, FULL_WIDGET, HALF_WIDGET } e_widget_size;

typedef struct s_widget {
	const char *name;
	const char *conf;
	e_widget_size size;
	void (*draw)( unsigned force, int x, int y );
	void (*click)( );
	unsigned cell;
} s_widget;

typedef struct s_widget_cell {
	e_widget_size size;
	s_widget *left;
	s_widget *right;
} s_widget_cell;

#define MAX_WIDGET_CELLS 20
extern s_widget_cell landscape_cells[MAX_WIDGET_CELLS];
extern s_widget_cell portrait_cells[MAX_WIDGET_CELLS];

//////////////////////////////////////////////////////////////////////////

typedef struct s_button {
	const char *name;
	const char *conf;
	void (*draw)( unsigned force, int x, int y );
	void (*click)( );
	unsigned cell;
} s_button;

#define MAX_BUTTON_CELLS 20
extern s_button *landscape_bcells[MAX_BUTTON_CELLS];
extern s_button *portrait_bcells[MAX_BUTTON_CELLS];

//////////////////////////////////////////////////////////////////////////

void config_init( );
void config_reload( );

#define conf_get_bool(key) gconf_client_get_bool(gconf_client, key, (GError **)NULL)
#define conf_get_int(key) gconf_client_get_int(gconf_client, key, (GError **)NULL)
#define conf_get_float(key) gconf_client_get_float(gconf_client, key, (GError **)NULL)
#define conf_get_string(key) gconf_client_get_string(gconf_client, key, (GError **)NULL)

#define conf_set_bool(key, value) gconf_client_set_bool(gconf_client, key, value, (GError **)NULL)
#define conf_set_int(key, value) gconf_client_set_int(gconf_client, key, value, (GError **)NULL)
#define conf_set_float(key, value) gconf_client_set_float(gconf_client, key, value, (GError **)NULL)
#define conf_set_string(key, value) gconf_client_set_string(gconf_client, key, value, (GError **)NULL)

#define conf_get_screen_autolock_value() gconf_client_get_bool(gconf_client, conf_screen_autolock1, (GError **)NULL)
#define conf_get_screen_stayslit_value() gconf_client_get_bool(gconf_client, conf_screen_stayslit1, (GError **)NULL)
void conf_set_screen_autolock_value( unsigned value );
void conf_set_screen_stayslit_value( unsigned value );

void config_save_widget( s_widget *widget, unsigned cell, unsigned subcell, unsigned landscape );

#define conf_get_screen_blank_offset() \
	gconf_client_get_int(gconf_client, conf_blank_timeout, (GError **)NULL) - gconf_client_get_int(gconf_client, conf_dim_timeout, (GError **)NULL)
