//  Advanced System UI
//  Copyright (c) 2010-2011 Brand Huntsman <brand.huntsman@gmail.com>

//#define CLEAR_KEYS

#include <stdio.h>
#include <stdlib.h>
#include <glib.h>

#include "main.h"
 #include "config.h"
#include "hardware.h"

////////////////////////////////////////////////////////////////////////// GLOBALS

const char *conf_max_brightness = "/system/osso/dsm/display/max_display_brightness_levels";
const char *conf_brightness = "/system/osso/dsm/display/display_brightness";
const char *conf_dim_timeout = "/system/osso/dsm/display/display_dim_timeout";
const char *conf_blank_timeout = "/system/osso/dsm/display/display_blank_timeout";
const char *conf_volume = "/apps/osso/sound/master_volume";
const char *conf_screen_autolock1 = "/apps/osso/applet/osso-applet-display/lock_screen";
const char *conf_screen_autolock2 = "/system/osso/dsm/locks/touchscreen_keypad_autolock_enabled";
const char *conf_screen_stayslit1 = "/apps/osso/applet/osso-applet-display/display_charger";
const char *conf_screen_stayslit2 = "/system/osso/dsm/display/display_on_with_charger";

const char *conf_brightness_level = "/apps/asui_state/brightness_level";
const char *conf_theme = "/apps/asui_state/theme";
const char *conf_ssh_server = "/apps/asui_state/ssh_server";

const char *conf_alarm_open = "/apps/asui_state/alarm_open";
const char *conf_alarm_tklock = "/apps/asui_state/alarm_tklock";
const char *conf_alarm_cb_service = "/apps/asui_state/alarm_cb_service";
const char *conf_alarm_cb_path = "/apps/asui_state/alarm_cb_path";
const char *conf_alarm_cb_iface = "/apps/asui_state/alarm_cb_iface";
const char *conf_alarm_cb_method = "/apps/asui_state/alarm_cb_method";
const char *conf_alarm_description = "/apps/asui_state/alarm_description";
const char *conf_alarm_sound = "/apps/asui_state/alarm_sound";
const char *conf_alarm_mode = "/apps/asui_state/alarm_mode";
const char *conf_alarm_timestamp = "/apps/asui_state/alarm_timestamp";

GConfClient *gconf_client;

// battery
unsigned cfg_battery_idle_time, cfg_memory_format, cfg_swap_format, cfg_temperature_F;
// clock
unsigned cfg_clock_24h, cfg_clock_ampm;
unsigned cfg_popup_duration, cfg_popup_onmap, cfg_popup_fullscreen, cfg_popup_cooldown, cfg_popup_noasui;
// brightness
unsigned cfg_brightness_enhanced, cfg_brightness_allow_zero;
// BRV keys
unsigned cfg_buttons_rotate, cfg_buttons_brightness, cfg_buttons_brightness_step, cfg_buttons_volume, cfg_buttons_volume_step;
// button modes
unsigned cfg_double_tap, cfg_lock_and_close, cfg_n800_lock_mode, cfg_rotate_and_close;
unsigned cfg_buttons_dpad_short, cfg_buttons_dpad_long, cfg_buttons_lock1_short, cfg_buttons_lock1_long, cfg_buttons_lock2_short, cfg_buttons_lock2_long;
unsigned cfg_secure_action, cfg_secure_power_action, cfg_secure_button;
unsigned cfg_power_unlock_key;
// user interface
unsigned cfg_service_size_unit, cfg_short_tap_markers, cfg_start_visible, cfg_threshold_black, cfg_threshold_white;
// alarm
unsigned cfg_alarm_duration, cfg_alarm_volume_min, cfg_alarm_volume_max, cfg_alarm_volume_step;

// state
unsigned cfg_theme, cfg_ssh_server;

////////////////////////////////////////////////////////////////////////// WIDGETS

extern s_widget widget_battery;
extern s_widget widget_brightness;
extern s_widget widget_volume;
extern s_widget widget_bluetooth;
extern s_widget widget_gps;
extern s_widget widget_wifi;
extern s_widget widget_clock;
extern s_widget widget_audio;
extern s_widget widget_desktop;
extern s_widget widget_ssh;
extern s_widget widget_vpn;
extern s_widget widget_usb;

s_widget_cell landscape_cells[MAX_WIDGET_CELLS];
s_widget_cell portrait_cells[MAX_WIDGET_CELLS];

extern s_button button_lock1;
extern s_button button_lock2;
extern s_button button_flight_mode;
extern s_button button_reboot;
extern s_button button_shutdown;
extern s_button button_rotate1;
extern s_button button_rotate2;
extern s_button button_rotate3;
extern s_button button_key_repeat;
extern s_button button_screen_stayslit;
extern s_button button_screen_autolock;
extern s_button button_settings;
extern s_button button_edit_widgets;

s_button *landscape_bcells[MAX_BUTTON_CELLS];
s_button *portrait_bcells[MAX_BUTTON_CELLS];

//////////////////////////////////////////////////////////////////////////

#ifdef ARCH_armel

// battery
static const char *conf_battery_idle_time = "/apps/asui/battery_idle_time";
static const char *conf_memory_format = "/apps/asui/memory_format";
static const char *conf_swap_format = "/apps/asui/swap_format";
static const char *conf_temperature_F = "/apps/asui/temperature_F";
// clock
static const char *conf_clock_24h = "/apps/asui/clock_24h";
static const char *conf_clock_ampm = "/apps/asui/clock_ampm";
static const char *conf_popup_duration = "/apps/asui/popup_duration";
static const char *conf_popup_onmap = "/apps/asui/popup_onmap";
static const char *conf_popup_fullscreen = "/apps/asui/popup_fullscreen";
static const char *conf_popup_cooldown = "/apps/asui/popup_cooldown";
static const char *conf_popup_noasui = "/apps/asui/popup_noasui";
// brightness
static const char *conf_brightness_enhanced = "/apps/asui/brightness_enhanced";
static const char *conf_brightness_allow_zero = "/apps/asui/brightness_allow_zero";
// BRV keys
static const char *conf_buttons_rotate = "/apps/asui/buttons_rotate";
static const char *conf_buttons_brightness = "/apps/asui/buttons_brightness";
static const char *conf_buttons_brightness_step = "/apps/asui/buttons_brightness_step";
static const char *conf_buttons_volume = "/apps/asui/buttons_volume";
static const char *conf_buttons_volume_step = "/apps/asui/buttons_volume_step";
// button modes
static const char *conf_double_tap = "/apps/asui/double_tap";
static const char *conf_lock_and_close = "/apps/asui/lock_and_close";
static const char *conf_n800_lock_mode = "/apps/asui/n800_lock_mode";
static const char *conf_rotate_and_close = "/apps/asui/rotate_and_close";
static const char *conf_buttons_dpad_short = "/apps/asui/buttons_dpad_short";
static const char *conf_buttons_dpad_long = "/apps/asui/buttons_dpad_long";
static const char *conf_buttons_lock1_short = "/apps/asui/buttons_lock1_short";
static const char *conf_buttons_lock1_long = "/apps/asui/buttons_lock1_long";
static const char *conf_buttons_lock2_short = "/apps/asui/buttons_lock2_short";
static const char *conf_buttons_lock2_long = "/apps/asui/buttons_lock2_long";
static const char *conf_secure_action = "/apps/asui/secure_action";
static const char *conf_secure_power_action = "/apps/asui/secure_power_action";
static const char *conf_secure_button = "/apps/asui/secure_button";
static const char *conf_power_unlock_key = "/apps/asui/power_unlock_key";
// user interface
static const char *conf_service_size_unit = "/apps/asui/service_size_unit";
static const char *conf_short_tap_markers = "/apps/asui/short_tap_markers";
static const char *conf_start_visible = "/apps/asui/start_visible";
static const char *conf_threshold_black = "/apps/asui/threshold_black";
static const char *conf_threshold_white = "/apps/asui/threshold_white";
// alarm
static const char *conf_alarm_duration = "/apps/asui/alarm_duration";
static const char *conf_alarm_volume_min = "/apps/asui/alarm_volume_min";
static const char *conf_alarm_volume_max = "/apps/asui/alarm_volume_max";
static const char *conf_alarm_volume_step = "/apps/asui/alarm_volume_step";


static void make_bool( unsigned *variable, const char *key, unsigned initial_value, unsigned flag ){
	GError *error = NULL; GConfError code;
	unsigned value;

	// test if key exists by querying with wrong type
	gconf_client_get_int(gconf_client, key, &error);
	if(error == NULL) code = GCONF_ERROR_BAD_KEY; else { code = error->code; g_error_free(error); }

	if(code == GCONF_ERROR_TYPE_MISMATCH){
		// key exists
		value = gconf_client_get_bool(gconf_client, key, NULL);
	} else {
		// create the key
		value = initial_value;
		conf_set_bool(key, value);
	}
	if(*variable != value){ *variable = value; hw_changes |= flag; }
}

#endif

// required by x86 code
static void make_uint( unsigned *variable, const char *key, unsigned initial_value, unsigned flag ){
	GError *error = NULL; GConfError code;
	int value;

	// test if key exists by querying with wrong type
	gconf_client_get_bool(gconf_client, key, &error);
	if(error == NULL) code = GCONF_ERROR_BAD_KEY; else { code = error->code; g_error_free(error); }

	if(code == GCONF_ERROR_TYPE_MISMATCH){
		// key exists
		value = gconf_client_get_int(gconf_client, key, NULL);
		if(value < 0){ value = initial_value; conf_set_int(key, value); }
	} else {
		// create the key
		value = initial_value;
		conf_set_int(key, value);
	}
	if(*variable != (unsigned)value){ *variable = value; hw_changes |= flag; }
}

/*
static void make_float( float *variable, const char *key, float initial_value, unsigned flag ){
	GError *error = NULL; GConfError code;
	float value;

	// test if key exists by querying with wrong type
	gconf_client_get_bool(gconf_client, key, &error);
	if(error == NULL) code = GCONF_ERROR_BAD_KEY; else { code = error->code; g_error_free(error); }

	if(code == GCONF_ERROR_TYPE_MISMATCH){
		// key exists
		value = gconf_client_get_float(gconf_client, key, NULL);
	} else {
		// create the key
		value = initial_value;
		conf_set_float(key, value);
	}
	if(*variable != value){ *variable = value; hw_changes |= flag; }
}
*/

////////////////////////////////////////////////////////////////////////// BUTTON CELLS

static unsigned load_button( s_button *button, unsigned initial_cell, unsigned force_initial ){
	landscape_bcells[initial_cell] = button;
	portrait_bcells[initial_cell] = button;

	return 1;
}

static unsigned load_buttons( unsigned force_initial ){
	int i;
	for(i = 0; i < MAX_BUTTON_CELLS; i++){
		landscape_bcells[i] = NULL;
		portrait_bcells[i] = NULL;
	}
	if(!load_button(&button_lock1,				 0, force_initial)) return 0;
	if(!load_button(&button_lock2,				 1, force_initial)) return 0;
	if(!load_button(&button_flight_mode,		 2, force_initial)) return 0;
	if(!load_button(&button_reboot,				 4, force_initial)) return 0;
	if(!load_button(&button_shutdown,			 5, force_initial)) return 0;
	if(!load_button(&button_rotate1,			 7, force_initial)) return 0;
	if(!load_button(&button_rotate2,			 8, force_initial)) return 0;
	if(!load_button(&button_rotate3,			 9, force_initial)) return 0;
	if(!load_button(&button_key_repeat,			10, force_initial)) return 0;
	if(!load_button(&button_screen_stayslit,	14, force_initial)) return 0;
	if(!load_button(&button_screen_autolock,	15, force_initial)) return 0;
	if(!load_button(&button_settings,			17, force_initial)) return 0;
	if(!load_button(&button_edit_widgets,		19, force_initial)) return 0;

// TODO: any new buttons MUST use an automatic placement technique unless force_initial is set
// TODO: add a function that scans for an empty cell in both orientations and returns the value, call when !force_initial

	return 1;
}

////////////////////////////////////////////////////////////////////////// WIDGET CELLS

static unsigned add_cell( s_widget_cell cells[], s_widget *widget, unsigned cell ){
	unsigned subcell = cell&0x0f, i = (cell&0xf0)>>4;
	switch(cells[i].size){
	case EMPTY_CELL:
		// cell is empty, initialize it and store widget
		if(widget->size == FULL_WIDGET){
			cells[i].size = FULL_WIDGET;
			cells[i].left = widget;
		} else {
			cells[i].size = HALF_WIDGET;
			if(subcell) cells[i].right = widget; else cells[i].left = widget;
		}
		break;
	case HALF_WIDGET:
		if(subcell){
			// right cell
			if(cells[i].right) return 0; // cell has already been used
			cells[i].right = widget;
		} else {
			// left cell
			if(cells[i].left) return 0; // cell has already been used
			cells[i].left = widget;
		}
		break;
	case FULL_WIDGET:
		return 0; // cell has already been used
	}

	return 1;
}

static unsigned load_widget( s_widget *widget, unsigned initial_cell, unsigned force_initial ){
	unsigned cell;

	if(force_initial){
		// cells are corrupt, use initial values
		cell = initial_cell;
		conf_set_int(widget->conf, cell);
	} else {
		// create gconf key or fetch previous value for cell location
		make_uint(&cell, widget->conf, initial_cell, 0);
	}

	// add widget to landscape and portrait orientations
	if(!add_cell(landscape_cells, widget, cell&0x00ff)) return 0;
	if(!add_cell(portrait_cells, widget, (cell&0xff00)>>8)) return 0;

	widget->cell = cell;
	return 1;
}

static unsigned load_widgets( unsigned force_initial ){
	int i;
	for(i = 0; i < MAX_WIDGET_CELLS; i++){
		s_widget_cell *cell = &landscape_cells[i];
		cell->size = EMPTY_CELL;
		cell->left = cell->right = NULL;
		cell = &portrait_cells[i];
		cell->size = EMPTY_CELL;
		cell->left = cell->right = NULL;
	}//																			portrait	landscape
	if(!load_widget(&widget_battery,	0x0010, force_initial)) return 0;//	P	0			1
	if(!load_widget(&widget_brightness,	0x1000, force_initial)) return 0;//	P	1			0
	if(!load_widget(&widget_volume,		0x2040, force_initial)) return 0;//	P	2			4
	if(!load_widget(&widget_bluetooth,	0x4060, force_initial)) return 0;//	P	4			6
	if(!load_widget(&widget_gps,		0x5070, force_initial)) return 0;//	P	5			7
	if(!load_widget(&widget_wifi,		0x6030, force_initial)) return 0;//	P	6			3
	if(!load_widget(&widget_clock,		0x3050, force_initial)) return 0;//	P	3-L			5-L
	if(!load_widget(&widget_audio,		0x3151, force_initial)) return 0;//	P	3-R			5-R
	if(!load_widget(&widget_desktop,	0x7020, force_initial)) return 0;//	S	7-L			2-L
	if(!load_widget(&widget_ssh,		0x7121, force_initial)) return 0;//	S	7-R			2-R
	if(!load_widget(&widget_vpn,		0xb091, force_initial)) return 0;//	S	3-L			9-R
	if(!load_widget(&widget_usb,		0xb1d0, force_initial)) return 0;// S	3-R			13-L

// TODO: any new widgets MUST use an automatic placement technique unless force_initial is set
// TODO: add a function that scans for an empty cell in both orientations and returns the value, call when !force_initial

	return 1;
}

//////////////////////////////////////////////////////////////////////////

static unsigned prev_brightness_enhanced, prev_battery_idle_time;
static unsigned first_config_load;

void config_init( ){
	g_type_init();
	gconf_client = gconf_client_get_default();

	prev_brightness_enhanced = prev_battery_idle_time = 0;

	#ifdef CLEAR_KEYS
	// battery
	gconf_client_unset(gconf_client, conf_battery_idle_time, NULL);
	gconf_client_unset(gconf_client, conf_memory_format, NULL);
	gconf_client_unset(gconf_client, conf_swap_format, NULL);
	gconf_client_unset(gconf_client, conf_temperature_F, NULL);
	// clock
	gconf_client_unset(gconf_client, conf_clock_24h, NULL);
	gconf_client_unset(gconf_client, conf_clock_ampm, NULL);
	gconf_client_unset(gconf_client, conf_popup_duration, NULL);
	gconf_client_unset(gconf_client, conf_popup_onmap, NULL);
	gconf_client_unset(gconf_client, conf_popup_fullscreen, NULL);
	gconf_client_unset(gconf_client, conf_popup_cooldown, NULL);
	gconf_client_unset(gconf_client, conf_popup_noasui, NULL);
	// brightness
	gconf_client_unset(gconf_client, conf_brightness_enhanced, NULL);
	gconf_client_unset(gconf_client, conf_brightness_allow_zero, NULL);
	// BRV keys
	gconf_client_unset(gconf_client, conf_buttons_rotate, NULL);
	gconf_client_unset(gconf_client, conf_buttons_brightness, NULL);
	gconf_client_unset(gconf_client, conf_buttons_brightness_step, NULL);
	gconf_client_unset(gconf_client, conf_buttons_volume, NULL);
	gconf_client_unset(gconf_client, conf_buttons_volume_step, NULL);
	// button modes
	gconf_client_unset(gconf_client, conf_double_tap, NULL);
	gconf_client_unset(gconf_client, conf_lock_and_close, NULL);
	gconf_client_unset(gconf_client, conf_n800_lock_mode, NULL);
	gconf_client_unset(gconf_client, conf_rotate_and_close, NULL);
	gconf_client_unset(gconf_client, conf_buttons_dpad_short, NULL);
	gconf_client_unset(gconf_client, conf_buttons_dpad_long, NULL);
	gconf_client_unset(gconf_client, conf_buttons_lock1_short, NULL);
	gconf_client_unset(gconf_client, conf_buttons_lock1_long, NULL);
	gconf_client_unset(gconf_client, conf_buttons_lock2_short, NULL);
	gconf_client_unset(gconf_client, conf_buttons_lock2_long, NULL);
	gconf_client_unset(gconf_client, conf_secure_action, NULL);
	gconf_client_unset(gconf_client, conf_secure_power_action, NULL);
	gconf_client_unset(gconf_client, conf_secure_button, NULL);
	gconf_client_unset(gconf_client, conf_power_unlock_key, NULL);
	// user interface
	gconf_client_unset(gconf_client, conf_service_size_unit, NULL);
	gconf_client_unset(gconf_client, conf_short_tap_markers, NULL);
	gconf_client_unset(gconf_client, conf_start_visible, NULL);
	gconf_client_unset(gconf_client, conf_threshold_black, NULL);
	gconf_client_unset(gconf_client, conf_threshold_white, NULL);

	gconf_client_unset(gconf_client, conf_alarm_duration, NULL);
	gconf_client_unset(gconf_client, conf_alarm_volume_min, NULL);
	gconf_client_unset(gconf_client, conf_alarm_volume_max, NULL);
	gconf_client_unset(gconf_client, conf_alarm_volume_step, NULL);

	gconf_client_unset(gconf_client, "/apps/asui", NULL);

	gconf_client_unset(gconf_client, button_lock1.conf, NULL);
	gconf_client_unset(gconf_client, button_lock2.conf, NULL);
	gconf_client_unset(gconf_client, button_flight_mode.conf, NULL);
	gconf_client_unset(gconf_client, button_reboot.conf, NULL);
	gconf_client_unset(gconf_client, button_shutdown.conf, NULL);
	gconf_client_unset(gconf_client, button_rotate1.conf, NULL);
	gconf_client_unset(gconf_client, button_rotate2.conf, NULL);
	gconf_client_unset(gconf_client, button_rotate3.conf, NULL);
	gconf_client_unset(gconf_client, button_key_repeat.conf, NULL);
	gconf_client_unset(gconf_client, button_screen_stayslit.conf, NULL);
	gconf_client_unset(gconf_client, button_screen_autolock.conf, NULL);
	gconf_client_unset(gconf_client, button_settings.conf, NULL);
	gconf_client_unset(gconf_client, button_edit_widgets.conf, NULL);

	gconf_client_unset(gconf_client, widget_battery.conf, NULL);
	gconf_client_unset(gconf_client, widget_brightness.conf, NULL);
	gconf_client_unset(gconf_client, widget_volume.conf, NULL);
	gconf_client_unset(gconf_client, widget_bluetooth.conf, NULL);
	gconf_client_unset(gconf_client, widget_gps.conf, NULL);
	gconf_client_unset(gconf_client, widget_wifi.conf, NULL);
	gconf_client_unset(gconf_client, widget_clock.conf, NULL);
	gconf_client_unset(gconf_client, widget_audio.conf, NULL);
	gconf_client_unset(gconf_client, widget_desktop.conf, NULL);
	gconf_client_unset(gconf_client, widget_ssh.conf, NULL);
	gconf_client_unset(gconf_client, widget_vpn.conf, NULL);
	gconf_client_unset(gconf_client, widget_usb.conf, NULL);
	gconf_client_unset(gconf_client, conf_brightness_level, NULL);
	gconf_client_unset(gconf_client, conf_theme, NULL);
	gconf_client_unset(gconf_client, conf_ssh_server, NULL);
	gconf_client_unset(gconf_client, "/apps/asui_state", NULL);

	printf("all gconf keys cleared\n");
	exit(EXIT_SUCCESS);
	#endif

	// key no longer used, remove it
	gconf_client_unset(gconf_client, "/apps/asui/no_save_unders", NULL); // removed in 0.2.8
	gconf_client_unset(gconf_client, "/apps/asui/brightness_level", NULL); // removed in 0.4.5

	first_config_load = 1;
	config_reload();
	first_config_load = 0;

	// initialize button cells
	if(!load_buttons(0)){
		error_write("button cells are corrupted, reverting to defaults");
		if(!load_buttons(1)){
			error_write("button cells are corrupted AND THE DEFAULTS ARE BAD TOO!!!");
			exit(EXIT_FAILURE);
		}
	}

	// initialize widget cells
	if(!load_widgets(0)){
		error_write("widget cells are corrupted, reverting to defaults");
		if(!load_widgets(1)){
			error_write("widget cells are corrupted AND THE DEFAULTS ARE BAD TOO!!!");
			exit(EXIT_FAILURE);
		}
	}
}

void config_reload( ){
	#ifdef ARCH_armel
	// battery
	make_bool(&cfg_battery_idle_time,		conf_battery_idle_time,			0,		HW_BATTERY);		// default: 0	don't show idle time
	make_uint(&cfg_memory_format,			conf_memory_format,				3,		HW_BATTERY);		// default: 3	used/total
	make_uint(&cfg_swap_format,				conf_swap_format,				1,		HW_BATTERY);		// default: 1	% used
	make_bool(&cfg_temperature_F,			conf_temperature_F,				0,		HW_TEMPERATURE);	// default: 0	celsius
	// clock
	make_bool(&cfg_clock_24h,				conf_clock_24h,					1,		0);					// default: 1	24 hour clock
	make_bool(&cfg_clock_ampm,				conf_clock_ampm,				0,		0);					// default: 0	24 hour clock doesn't use this
	make_uint(&cfg_popup_duration,			conf_popup_duration,			0,		0);					// default: 0	popup diabled
	make_bool(&cfg_popup_onmap,				conf_popup_onmap,				0,		0);					// default: 0	off
	make_bool(&cfg_popup_fullscreen,		conf_popup_fullscreen,			0,		0);					// default: 0	small popup window
	make_uint(&cfg_popup_cooldown,			conf_popup_cooldown,			300,	0);					// default: 300	5 minutes
	make_bool(&cfg_popup_noasui,			conf_popup_noasui,				1,		0);					// default: 1	don't show while ASUI mapped
	// brightness
	make_bool(&cfg_brightness_enhanced,		conf_brightness_enhanced,		!is_770,HW_BRIGHTNESS);		// default: 1	all 127 brightness levels
	make_bool(&cfg_brightness_allow_zero,	conf_brightness_allow_zero,		0,		HW_BRIGHTNESS);		// default: 0	don't allow zero brightness
	// BRV keys
	make_uint(&cfg_buttons_rotate,			conf_buttons_rotate,			1,		0);					// default: 1	zoom buttons
	make_uint(&cfg_buttons_brightness,		conf_buttons_brightness,		2,		0);					// default: 2	up/down buttons
	make_uint(&cfg_buttons_brightness_step,	conf_buttons_brightness_step,	10,		0);					// default: 10
	make_uint(&cfg_buttons_volume,			conf_buttons_volume,			3,		0);					// default: 3	left/right buttons
	make_uint(&cfg_buttons_volume_step,		conf_buttons_volume_step,		10,		0);					// default: 10
	// button modes
	make_bool(&cfg_double_tap,				conf_double_tap,				1,		0);					// default: 1	require double taps where available
	make_bool(&cfg_lock_and_close,			conf_lock_and_close,			1,		0);					// default: 1	close window after using on-screen lock buttons
	make_bool(&cfg_n800_lock_mode,			conf_n800_lock_mode,			!is_810,0);					// default: -	enabled for n800/770
	make_bool(&cfg_rotate_and_close,		conf_rotate_and_close,			1,		0);					// default: 1	close window after using on-screen rotation buttons
	make_uint(&cfg_buttons_dpad_short,		conf_buttons_dpad_short,		1,		0);					// default: 0	lock
	make_uint(&cfg_buttons_dpad_long,		conf_buttons_dpad_long,			4,		0);					// default: 0	secure
	make_uint(&cfg_buttons_lock1_short,		conf_buttons_lock1_short,		2,		HW_THEME);			// default: 0	lock&blank
	make_uint(&cfg_buttons_lock1_long,		conf_buttons_lock1_long,		3,		HW_THEME);			// default: 0	blank
	make_uint(&cfg_buttons_lock2_short,		conf_buttons_lock2_short,		1,		HW_THEME);			// default: 0	lock
	make_uint(&cfg_buttons_lock2_long,		conf_buttons_lock2_long,		4,		HW_THEME);			// default: 0	secure
	make_uint(&cfg_secure_action,			conf_secure_action,				2,		0);					// default: 0	lock&blank
	make_uint(&cfg_secure_power_action,		conf_secure_power_action,		1,		0);					// default: 0	lock&blank
	make_bool(&cfg_secure_button,			conf_secure_button,				0,		HW_THEME);			// default: 0	don't show secure button
	make_uint(&cfg_power_unlock_key,		conf_power_unlock_key,			1,		0);					// default: 1	power button + fullscreen key unlocks
	// user interface
	make_bool(&cfg_service_size_unit,		conf_service_size_unit,			1,		HW_THEME);			// default: 1	show MB with service sizes
	make_bool(&cfg_short_tap_markers,		conf_short_tap_markers,			0,		HW_THEME);			// default: 0	don't show short tap markers
	make_bool(&cfg_start_visible,			conf_start_visible,				0,		0);					// default: 0	not visible
	make_uint(&cfg_threshold_black,			conf_threshold_black,			3000,	HW_THEME);			// default: 	to black theme when below 3000 lux
	make_uint(&cfg_threshold_white,			conf_threshold_white,			4000,	HW_THEME);			// default: 	to white theme when 4000 lux or greater
	// alarm
	make_uint(&cfg_alarm_duration,			conf_alarm_duration,			60,		0);					// default:		10-3600 seconds
	make_uint(&cfg_alarm_volume_min,		conf_alarm_volume_min,			50,		0);					// default:		10-100
	make_uint(&cfg_alarm_volume_max,		conf_alarm_volume_max,			100,	0);					// default:		10-100
	make_uint(&cfg_alarm_volume_step,		conf_alarm_volume_step,			125,	0);					// default:		0-1000 milliseconds
	// state
	unsigned brightness_level;
	make_uint(&brightness_level,			conf_brightness_level,			31,		HW_BRIGHTNESS);		// default: 31	25% brightness
	unsigned theme = !is_810;
	make_uint(&cfg_theme,					conf_theme,						theme,	HW_THEME);			// default: 0/1	color theme
	make_uint(&cfg_ssh_server,				conf_ssh_server,				0,		HW_BRIGHTNESS);		// default: 0	openssh

	// memory and swap formats can be 0-3
	if(cfg_memory_format > 3){ cfg_memory_format = 0; conf_set_int(conf_memory_format, 0); }
	if(cfg_swap_format > 3){ cfg_swap_format = 0; conf_set_int(conf_swap_format, 0); }

	// popup window duration
	if(cfg_popup_duration > 15){ cfg_popup_duration = 5; conf_set_int(conf_popup_duration, 5); }
	if(cfg_popup_cooldown < 60 || cfg_popup_cooldown > 3600){ cfg_popup_cooldown = 300; conf_set_int(conf_popup_cooldown, 300); }
	if(cfg_popup_noasui) cfg_popup_onmap = 0;

	// make sure buttons are correctly bound and don't exceed step values
	if(cfg_buttons_rotate > 3){ cfg_buttons_rotate = 0; conf_set_int(conf_buttons_rotate, 0); } // disable if invalid
	if(cfg_buttons_brightness > 3) cfg_buttons_brightness = 0; // disable if invalid
	if(cfg_buttons_brightness_step == 0){ cfg_buttons_brightness_step = 1; conf_set_int(conf_buttons_brightness_step, 1); }
	else if(cfg_buttons_brightness_step > 20){ cfg_buttons_brightness_step = 20; conf_set_int(conf_buttons_brightness_step, 20); }
	if(cfg_buttons_volume > 3){ cfg_buttons_volume = 0; conf_set_int(conf_buttons_volume, 0); } // disable if invalid
	if(cfg_buttons_volume_step == 0){ cfg_buttons_volume_step = 1; conf_set_int(conf_buttons_volume_step, 1); }
	else if(cfg_buttons_volume_step > 20){ cfg_buttons_volume_step = 20; conf_set_int(conf_buttons_volume_step, 20); }
	if(cfg_buttons_rotate == cfg_buttons_brightness) cfg_buttons_brightness = 0; // disable brightness if rotate uses same button group
	if(cfg_buttons_rotate == cfg_buttons_volume || cfg_buttons_brightness == cfg_buttons_volume){
		cfg_buttons_volume = 0; conf_set_int(conf_buttons_volume, 0); } // disable volume if rotate or brightness uses same button group
	// make sure brightness is bound to hardware keys
	if(cfg_buttons_brightness == 0){
		if(cfg_buttons_rotate && cfg_buttons_volume)
			cfg_buttons_brightness = 6-(cfg_buttons_rotate+cfg_buttons_volume); // only one option available
		else if(cfg_buttons_rotate)
			cfg_buttons_brightness = (cfg_buttons_rotate == 2 ? 3 : 2); // put it on the d-pad
		else if(cfg_buttons_volume)
			cfg_buttons_brightness = (cfg_buttons_volume == 2 ? 3 : 2); // put it on the d-pad
		else
			cfg_buttons_brightness = 2; // put it on the up/down arrows
		conf_set_int(conf_buttons_brightness, cfg_buttons_brightness);
	}

	// bounds check lock buttons
	if(cfg_buttons_dpad_short > 4){ cfg_buttons_dpad_short = 0; conf_set_int(conf_buttons_dpad_short, 0); } // disable if invalid
	if(cfg_buttons_dpad_long > 4){ cfg_buttons_dpad_long = 0; conf_set_int(conf_buttons_dpad_long, 0); } // disable if invalid
	if(cfg_buttons_lock1_short > 4){ cfg_buttons_lock1_short = 0; conf_set_int(conf_buttons_lock1_short, 0); } // disable if invalid
	if(cfg_buttons_lock1_long > 4){ cfg_buttons_lock1_long = 0; conf_set_int(conf_buttons_lock1_long, 0); } // disable if invalid
	if(cfg_buttons_lock2_short > 4){ cfg_buttons_lock2_short = 0; conf_set_int(conf_buttons_lock2_short, 0); } // disable if invalid
	if(cfg_buttons_lock2_long > 4){ cfg_buttons_lock2_long = 0; conf_set_int(conf_buttons_lock2_long, 0); } // disable if invalid
	if(cfg_secure_action > 3){ cfg_secure_action = 0; conf_set_int(conf_secure_action, 0); } // disable if invalid
	if(cfg_secure_power_action > 2){ cfg_secure_power_action = 0; conf_set_int(conf_secure_power_action, 0); } // disable if invalid
	if(cfg_power_unlock_key > 5){ cfg_power_unlock_key = 1; conf_set_int(conf_power_unlock_key, 1); } // set to fullscreen if invalid

// override until 770 is supported
if(cfg_brightness_enhanced && is_770){ cfg_brightness_enhanced = 0; conf_set_bool(conf_brightness_enhanced, 0); } // disable

	// force brightness stepping to 1 when not using enhanced brightness levels
	if(!cfg_brightness_enhanced){
		cfg_buttons_brightness_step = 1;
		cfg_brightness_allow_zero = 0;
	}
	// only N810 can use zero brightness
	if(cfg_brightness_allow_zero && !is_810){ cfg_brightness_allow_zero = 0; conf_set_bool(conf_brightness_allow_zero, 0); } // disable

	// themes
	//		0 = ALS (n810 only)
	//		1 = black
	//		2 = white
	// only N810 can use ALS theme (0)
	if(cfg_theme == 0 && !is_810){ cfg_theme = 1; conf_set_int(conf_theme, 1); } // reset to black theme
	// make sure theme is valid
	if(cfg_theme > 2){ cfg_theme = 1; conf_set_int(conf_theme, 1); } // reset to black theme

	if(!first_config_load){
		// re-initialize brightness when changed
		if(cfg_brightness_enhanced != prev_brightness_enhanced)
			brightness_init();

		// get battery idle time when checked
		if(cfg_battery_idle_time && !prev_battery_idle_time)
			hw_query_battery(1); // flush
	}

	// alarm
	if(cfg_alarm_duration > 3600 || cfg_alarm_duration < 10){ cfg_alarm_duration = 60; conf_set_int(conf_alarm_duration, 60); }
	if(cfg_alarm_volume_min > 100 || cfg_alarm_volume_min < 10){ cfg_alarm_volume_min = 50; conf_set_int(conf_alarm_volume_min, 50); }
	if(cfg_alarm_volume_max > 100 || cfg_alarm_volume_max < cfg_alarm_volume_min){ cfg_alarm_volume_max = 100; conf_set_int(conf_alarm_volume_max, 100); }
	if(cfg_alarm_volume_step > 1000){ cfg_alarm_volume_step = 125; conf_set_int(conf_alarm_volume_step, 125); }

	prev_brightness_enhanced = cfg_brightness_enhanced;
	prev_battery_idle_time = cfg_battery_idle_time;

	#else

	cfg_start_visible = 1; // no power button to map it
	cfg_clock_24h = 1; // because I like 24 hour
	cfg_popup_duration = 0;
	cfg_popup_onmap = 0;
	cfg_threshold_white = 4000; // must be set otherwise white theme is used
	cfg_short_tap_markers = 1; // show all markers
	cfg_double_tap = 1; // require double tap
	cfg_buttons_dpad_short = 1;
	cfg_buttons_dpad_long = 4;
	cfg_buttons_lock1_short = 1;
	cfg_buttons_lock1_long = 3;
	cfg_buttons_lock2_short = 2;
	cfg_buttons_lock2_long = 4;
	cfg_secure_action = 2;
	cfg_secure_power_action = 1;
	cfg_secure_button = 1; // disable secure buttons

	cfg_theme = 1; // no ALS sensor, use blank theme
	cfg_ssh_server = 0; // openssh

	#endif

// TODO: control panel applet will send message to main loop when settings need to be reloaded

	debug_write("SETTINGS");
	// battery
	debug_write("  cfg_battery_idle_time = %u", cfg_battery_idle_time);
	debug_write("  cfg_memory_format = %u", cfg_memory_format);
	debug_write("  cfg_swap_format = %u", cfg_swap_format);
	debug_write("  cfg_temperature_F = %u", cfg_temperature_F);
	// clock
	debug_write("  cfg_clock_24h = %u", cfg_clock_24h);
	debug_write("  cfg_clock_ampm = %u", cfg_clock_ampm);
	debug_write("  cfg_popup_duration = %u", cfg_popup_duration);
	debug_write("  cfg_popup_onmap = %u", cfg_popup_onmap);
	debug_write("  cfg_popup_fullscreen = %u", cfg_popup_fullscreen);
	debug_write("  cfg_popup_cooldown = %u", cfg_popup_cooldown);
	debug_write("  cfg_popup_noasui = %u", cfg_popup_noasui);
	// brightness
	debug_write("  cfg_brightness_enhanced = %u", cfg_brightness_enhanced);
	debug_write("  cfg_brightness_allow_zero = %u", cfg_brightness_allow_zero);
	// BRV keys
	debug_write("  cfg_buttons_rotate = %u", cfg_buttons_rotate);
	debug_write("  cfg_buttons_brightness = %u", cfg_buttons_brightness);
	debug_write("  cfg_buttons_brightness_step = %u", cfg_buttons_brightness_step);
	debug_write("  cfg_buttons_volume = %u", cfg_buttons_volume);
	debug_write("  cfg_buttons_volume_step = %u", cfg_buttons_volume_step);
	// button modes
	debug_write("  cfg_double_tap = %u", cfg_double_tap);
	debug_write("  cfg_lock_and_close = %u", cfg_lock_and_close);
	debug_write("  cfg_n800_lock_mode = %u", cfg_n800_lock_mode);
	debug_write("  cfg_rotate_and_close = %u", cfg_rotate_and_close);
	debug_write("  cfg_buttons_dpad_short = %u", cfg_buttons_dpad_short);
	debug_write("  cfg_buttons_dpad_long = %u", cfg_buttons_dpad_long);
	debug_write("  cfg_buttons_lock1_short = %u", cfg_buttons_lock1_short);
	debug_write("  cfg_buttons_lock1_long = %u", cfg_buttons_lock1_long);
	debug_write("  cfg_buttons_lock2_short = %u", cfg_buttons_lock2_short);
	debug_write("  cfg_buttons_lock2_long = %u", cfg_buttons_lock2_long);
	debug_write("  cfg_secure_action = %u", cfg_secure_action);
	debug_write("  cfg_secure_power_action = %u", cfg_secure_power_action);
	debug_write("  cfg_secure_button = %u", cfg_secure_button);
	debug_write("  cfg_power_unlock_key = %u", cfg_power_unlock_key);
	// user interface
	debug_write("  cfg_service_size_unit = %u", cfg_service_size_unit);
	debug_write("  cfg_short_tap_markers = %u", cfg_short_tap_markers);
	debug_write("  cfg_start_visible = %u", cfg_start_visible);
	debug_write("  cfg_threshold_black = %u", cfg_threshold_black);
	debug_write("  cfg_threshold_white = %u", cfg_threshold_white);
	// alarm
	debug_write("  cfg_alarm_duration = %u", cfg_alarm_duration);
	debug_write("  cfg_alarm_volume_min = %u", cfg_alarm_volume_min);
	debug_write("  cfg_alarm_volume_max = %u", cfg_alarm_volume_max);
	debug_write("  cfg_alarm_volume_step = %.3f", cfg_alarm_volume_step);

	debug_write("STATE");
	// state
	debug_write("  brightness_level = %u", brightness_level);
	debug_write("  cfg_theme = %u", cfg_theme);
	debug_write("  cfg_ssh_server = %u", cfg_ssh_server);
	debug_write("------------------------------");
}

void conf_set_screen_autolock_value( unsigned value ){
	conf_set_bool(conf_screen_autolock1, value);
	conf_set_bool(conf_screen_autolock2, value);
}

void conf_set_screen_stayslit_value( unsigned value ){
	conf_set_bool(conf_screen_stayslit1, value);
	conf_set_bool(conf_screen_stayslit2, value);
}

void config_save_widget( s_widget *widget, unsigned cell, unsigned subcell, unsigned landscape ){
	if(landscape)
		widget->cell = (widget->cell&0xff00) | cell<<4 | subcell;
	else
		widget->cell = (widget->cell&0x00ff) | cell<<12 | subcell<<8;

//printf("saving %s to 0x%X%d (0x%X)\n", widget->name, cell, subcell, widget->cell);

	conf_set_int(widget->conf, widget->cell);
}
