//	Advanced System UI
//	Copyright (c) 2011 Brand Huntsman <brand.huntsman@gmail.com>

#include "window.h"
#include "main.h"
#include "draw.h"
#include "text.h"
#include "config.h"
#include "hardware.h"

//////////////////////////////////////////////////////////////////////////

void draw_screen_autolock_button( unsigned force, int x, int y ){
	if(force){
		// background for all buttons is cleared by draw_window()
		screenautolock_button_page = primary_widgets;
	} else if(hw_changes & HW_SCREEN_AUTOLOCK){
		// button background
		x_set_color(bg_color);
		x_fill_rectangle(x, y, 80, 80);
	} else return;

	unsigned cx = x+40, cy = y+40;

	draw_text("screen", 16, fg2_color, cx, cy-14, ALIGN_CENTER, ALIGN_BASELINE, 0);
	draw_text("autolock", 16, fg2_color, cx, cy+6, ALIGN_CENTER, ALIGN_BASELINE, 0);
	if(hw_screen_autolock)
		draw_text("ON", 16, fg1_color, cx, cy+26, ALIGN_CENTER, ALIGN_BASELINE, 0);
	else
		draw_text("OFF", 16, fg1_color, cx, cy+26, ALIGN_CENTER, ALIGN_BASELINE, 0);

	draw_tap_markers(x, y, 80, 1, 0); // short tap only
}

//////////////////////////////////////////////////////////////////////////

void click_screen_autolock_button( ){
	if(click.type != CLICK_SHORT) return;

	highlight_selected_area(widget_x, widget_y, 80,80);
	conf_set_screen_autolock_value(!conf_get_screen_autolock_value()); // toggle
	hw_screen_autolock = (hw_screen_autolock ? 0 : 1);

	// redraw button
	x_set_color(bg_color);
	x_fill_rectangle(widget_x, widget_y, 80, 80);
	draw_screen_autolock_button(1, widget_x, widget_y);
	x_flush();
}

////////////////////////////////////////////////////////////////////////// BUTTON

s_button button_screen_autolock = {"*autolock", "/apps/asui_state/bcell_screen_autolock", draw_screen_autolock_button, click_screen_autolock_button, 0};
