//	Advanced System UI
//	Copyright (c) 2010-2011 Brand Huntsman <brand.huntsman@gmail.com>

#include "window.h"
#include "main.h"
#include "draw.h"
#include "config.h"
#include "services.h"
#include "hardware.h"

//////////////////////////////////////////////////////////////////////////

void draw_flight_mode_button( unsigned force, int x, int y ){
	if(force){
		// background for all buttons is cleared by draw_window()
		flightmode_button_page = primary_widgets;
	} else if(hw_changes & HW_FLIGHT_MODE){
		// button background
		x_set_color(bg_color);
		x_fill_rectangle(x, y, 80, 80);
	} else return;

	draw_image((hw_flight_mode ? &im_tonormal : &im_toflight), x+8, y+8);

	draw_tap_markers(x, y, 80, 1, !hw_flight_mode); // short tap only (long tap when in normal mode)
}

//////////////////////////////////////////////////////////////////////////

static s_tap_throttler flight_throttle;

void click_flight_mode_button( ){
	if(click.type == CLICK_HOLD){

		if(!hw_flight_mode){
			// highlight to indicate long press
			highlight_long_press(widget_x, widget_y, 80,80);
		}

	} else if(click.type == CLICK_SHORT){

		if(throttle_taps(&flight_throttle)) return;

		highlight_selected_area(widget_x, widget_y, 80,80);

		// toggle between normal and offline modes
		if(hw_flight_mode)
			mce_normal_mode();
		else
			mce_flight_mode();

		finalize_tap(flight_throttle);

		// redraw button
		draw_flight_mode_button(0, widget_x, widget_y);
		hw_changes &= ~HW_FLIGHT_MODE;
		x_flush();

		// signals will cause effected widgets to be redrawn

	} else if(click.type == CLICK_LONG){

		if(!hw_flight_mode){
			highlight_selected_area(widget_x, widget_y, 80,80); // highlight removed when window is redrawn

			// enter flight mode and stop all related services
			mce_flight_mode();
			svc_init_gps(SVC_STOP);
			svc_init_bluetooth(SVC_STOP, 0);
			svc_init_wifi(SVC_STOP, 0);
			svc_init_ssh(SVC_STOP, 1);
			svc_init_vpn(SVC_STOP);

			// redraw window
			draw_window(0);
		}

		// no long press to enter normal mode

	}
}

////////////////////////////////////////////////////////////////////////// BUTTON

s_button button_flight_mode = {"flight", "/apps/asui_state/bcell_flight_mode", draw_flight_mode_button, click_flight_mode_button, 0};
