#!/bin/sh

WIFI=`/usr/bin/dbus-send --print-reply --system --dest=com.nokia.icd2 /com/nokia/icd2 com.nokia.icd2.state_req |grep uint32 |sed "s:^.*uint32 ::"`
if [ "$WIFI" = "0" ]; then
	echo "Connecting for you, try again in a few seconds"
	# auto-connect wifi
	/usr/bin/dbus-send --system --type=method_call --dest=com.nokia.icd /com/nokia/icd com.nokia.icd.connect string:"[ANY]" uint32:0
	exit 1
fi

if [ "$1" = "fixme" ]; then
	echo "Downloading new installer..."
	maemo-mini-curl -o install-advanced-systemui.sh http://qzx.com/tmp/advanced-systemui/install-advanced-systemui.sh || exit
	[ ! -d /root/bin ] && mkdir /root/bin
	mv install-advanced-systemui.sh /root/bin/
	chmod 700 /root/bin/install-advanced-systemui.sh
	exit 1
fi

echo "Downloading files..."
maemo-mini-curl -o advanced-systemui http://qzx.com/tmp/advanced-systemui/advanced-systemui
maemo-mini-curl -o advanced-systemui.sudoers http://qzx.com/tmp/advanced-systemui/advanced-systemui.sudoers
maemo-mini-curl -o advanced-systemui.desktop http://qzx.com/tmp/advanced-systemui/advanced-systemui.desktop

[ ! -e advanced-systemui -o ! -e advanced-systemui.sudoers -o ! -e advanced-systemui.desktop ] \
	&& echo "One or more downloads failed, try again" && exit 1

echo "Installing files..."
mv advanced-systemui /usr/bin/ ; chmod 755 /usr/bin/advanced-systemui
mv advanced-systemui.sudoers /etc/sudoers.d/ ; update-sudoers
mv advanced-systemui.desktop /usr/share/applications/hildon/

if [ -z "`grep advanced-systemui /home/user/.osso/menus/applications.menu`" ]; then
	echo "Adding advanced-systemui to application menu..."
	sed -i "s:</Include></Menu></Menu>:<Filename>advanced-systemui.desktop</Filename></Include></Menu></Menu>:" \
		/home/user/.osso/menus/applications.menu
	chown user.users /home/user/.osso/menus/applications.menu
fi
