//	Advanced System UI
//	Copyright (c) 2010 Brand Huntsman <brand.huntsman@gmail.com>

#include "window.h"
#include "main.h"
#include "draw.h"
#include "text.h"
#include "config.h"
#include "services.h"
#include "hardware.h"

//////////////////////////////////////////////////////////////////////////

void draw_gps_widget( unsigned force, int x, int y ){
	if(force){
		// background for all widgets is cleared by draw_window()
	} else if(hw_changes & HW_GPS || svc_changes & SVC_GPS){
		// widget background
		x_set_color(bg_color);
		x_fill_rectangle(x, y, 399, 99);
	} else return;

	draw_text("GPS", 32, fg1_color, x+20, y+50, ALIGN_LEFT, ALIGN_MIDDLE, 0);
	if(0 && is_810)
		draw_hardware_indicator(hw_gps.enabled, x, y);
	else {
		// separator
		x_set_color(line_color);
		x_set_style(2, LineOnOffDash); // dotted line, 2 wide
		x_draw_line(x+199, y+20, x+199, y+80);
		x_reset_style();
	}
	draw_services_indicator(svc_gps_status, x+299, y+50, 60);
	draw_rss(svc_gps_size, x+390, y+90);

//	draw_tap_markers(x, y, 99, 1, 1); // short & long taps (enable/disable & location dialog)
	draw_tap_markers(x+200, y, 99, 1, 0); // short tap only (services)
}

//////////////////////////////////////////////////////////////////////////

static s_tap_throttler gps_throttle;

void click_gps_widget( ){
	if(click.type == CLICK_DOWN || click.type == CLICK_MOTION || click.type == CLICK_DRAG) return; // no drag support

	if(click.x >= 200){

		if(click.type != CLICK_SHORT) return; // no long press support

		// require double tap if enabled and service is fully started or stopped
		// partial state always uses a single tap
		if(svc_gps_status != 1)
			if(!get_double_tap(Z_MAIN_SVC_GPS)) return;

		if(throttle_taps(&gps_throttle)) return;

		{
			if(svc_gps_status == 1 && click.x >= 300){
				highlight_selected_area(widget_x+300, widget_y, 99, 99);
				svc_gps_status = 0; // attempt to start services
			} else
				highlight_selected_area(widget_x+200, widget_y, (svc_gps_status == 1 ? 99 : 199), 99);

			if(svc_gps_status)
				svc_init_gps(SVC_STOP);
			else
				svc_init_gps(SVC_START);

			svc_changes |= SVC_GPS;
			draw_gps_widget(0, widget_x, widget_y); // update service dot
		}

		finalize_tap(gps_throttle);

	} else if(is_810){

// TODO: start services and toggle hardware (don't require all services to be started to toggle hardware, optionals aren't needed)

	}
}

////////////////////////////////////////////////////////////////////////// WIDGET

s_widget widget_gps = {"GPS", "/apps/asui_state/cell_gps", FULL_WIDGET, draw_gps_widget, click_gps_widget, 0};
