//	Advanced System UI
//	Copyright (c) 2010-2011 Brand Huntsman <brand.huntsman@gmail.com>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "window.h"
#include "main.h"
#include "draw.h"
#include "text.h"
 #include "dialog.h"

////////////////////////////////////////////////////////////////////////// GLOBALS

// needed by main.c to draw window and handle clicks/keypresses
void(*current_dialog_draw)(unsigned force);
void(*current_dialog_click)();
void(*current_dialog_keypress)();
unsigned current_dialog_redraw;
void (*cdlg_yes_handler)();
void (*cdlg_no_handler)();
XColor *yes_color;

s_timer dialog_refresh_timer;

//////////////////////////////////////////////////////////////////////////

static void(*current_dialog_reset)();
static char *cdlg_message;

void dialog_init( ){
	current_dialog_reset = NULL;
	cdlg_message = NULL;
	dialog_reset();
}

int dialog_open( void(*draw_dialog)(unsigned force), void(*click_dialog)(), void(*keypress_dialog)(), void(*reset_dialog)(), e_dialog_redraw redraw ){
	if(draw_dialog == NULL) return 0; // need draw handler
	if(current_dialog_draw) return 0; // can't have more than one active dialog
	current_dialog_draw = draw_dialog;
	current_dialog_click = click_dialog;
	current_dialog_keypress = keypress_dialog;
	current_dialog_reset = reset_dialog;
	current_dialog_redraw = redraw;
	draw_window(1); // force it the first time
	return 1;
}

void dialog_close( ){
	dialog_reset();
	draw_window(1); // force
}

void dialog_reset( ){
	// set all widgets to the inactive page to avoid redraw problems
	brightness_widget_page = volume_widget_page = battery_widget_page = flightmode_button_page = keyrepeat_button_page = screenstayslit_button_page = screenautolock_button_page = !primary_widgets;

	if(current_dialog_reset) current_dialog_reset();
	current_dialog_draw = current_dialog_click = current_dialog_keypress = current_dialog_reset = NULL;
	current_dialog_redraw = DLG_REDRAW_ON;
	if(cdlg_message){ free(cdlg_message); cdlg_message = NULL; }
	cdlg_yes_handler = cdlg_no_handler = NULL;
	yes_color = NULL;

// TODO: unmaping asui with power button can use a very old click.timestamp which results in ASUI becoming unresponive for a very very long time when remapped

	// throttle taps when closing dialogs
//	throttle_taps(&ui_throttle);
//	finalize_tap(ui_throttle);
}

////////////////////////////////////////////////////////////////////////// CONFIRMATION DIALOG

unsigned cdlg_font_size;

void draw_cdlg_buttons( char *yes, char *no ){
	XColor *color = (yes_color ? yes_color : fg1_color);
	x_set_color(fg2_color);
	if(window.width > window.height){
		// LANDSCAPE
		x_draw_rectangle( 50, 250, 300,100);
		x_draw_rectangle(450, 250, 300,100);
		draw_text(yes, 24,     color, 200, 300, ALIGN_CENTER, ALIGN_MIDDLE, 0);
		draw_text(no,  24, fg1_color, 600, 300, ALIGN_CENTER, ALIGN_MIDDLE, 0);
	} else {
		// PORTRAIT
		x_draw_rectangle(90, 400, 300,100);
		x_draw_rectangle(90, 600, 300,100);
		draw_text(yes, 24,     color, 240, 450, ALIGN_CENTER, ALIGN_MIDDLE, 0);
		draw_text(no,  24, fg1_color, 240, 650, ALIGN_CENTER, ALIGN_MIDDLE, 0);
	}
}

static void draw_cdlg( unsigned force ){
	// force is not needed

	// dialog background
	x_set_color(bg_color);
	x_fill_rectangle(0, 0, window.width, window.height);

	// message
	if(cdlg_message)
		draw_text(cdlg_message, cdlg_font_size, fg1_color, window.width>>1, (window.width > window.height ? 125 : 200), ALIGN_CENTER, ALIGN_MIDDLE, window.width);

	// buttons
	draw_cdlg_buttons("Yes", "No");
}

static void yes_button( ){
	if(window.width > window.height)
		highlight_selected_area(50, 250, 301,101);
	else
		highlight_selected_area(90, 400, 301,101);

	if(cdlg_message){ free(cdlg_message); cdlg_message = NULL; }
	if(cdlg_yes_handler)
		cdlg_yes_handler();
	else
		dialog_close();
}

static void no_button( ){
	if(window.width > window.height)
		highlight_selected_area(450, 250, 301,101);
	else
		highlight_selected_area(90, 600, 301,101);

	if(cdlg_message){ free(cdlg_message); cdlg_message = NULL; }
	if(cdlg_no_handler)
		cdlg_no_handler();
	else
		dialog_close();
}

void click_cdlg( ){
	if(click.type != CLICK_SHORT) return; // no long press or drag support

	if(window.width > window.height){
		// LANDSCAPE
		if(click.y < 250 || click.y > 350) return;
		if(click.x >  50 && click.x < 350)
			yes_button();
		else if(click.x > 450 && click.x < 750)
			no_button();
		else return;
	} else {
		// PORTRAIT
		if(click.x <  90 || click.x > 390) return;
		if(click.y > 400 && click.y < 500)
			yes_button();
		else if(click.y > 600 && click.y < 700)
			no_button();
		else return;
	}
}

void keypress_cdlg( ){
	switch(keypress.keycode){
	case KEYCODE_ESCAPE:
		if(keypress.type == KEY_SHORT) no_button();
		break;
	case KEYCODE_HOME:
		if(keypress.type == KEY_SHORT) yes_button();
		break;
	default:
		if(!dpadlock_keypress_handler())
			brv_keypress_handler();
				// ignore all other keys
		break;
	}
}

int open_confirmation_dialog( char *message, void (*yes_handler)(), unsigned font_size ){
	// messages over 24 characters might be chopped off in portrait mode
	cdlg_yes_handler = yes_handler;
	cdlg_no_handler = NULL;
	if(message){
		cdlg_message = malloc(strlen(message)+1);
		debug_write("malloc in open_confirmation_dialog()");
		if(cdlg_message) strcpy(cdlg_message, message);
		cdlg_font_size = font_size;
	}
	if(dialog_open(draw_cdlg, click_cdlg, keypress_cdlg, NULL, DLG_REDRAW_OFF)) return 1; // no redraw
	if(cdlg_message){ free(cdlg_message); cdlg_message = NULL; }
	return 0;
}
