#!/bin/sh

if [ ! "`whoami`" = "root" ]; then
	echo "This script must be run as root"
	exit 1
fi

asui_connect()
{
	WIFI=`run-standalone.sh /usr/bin/dbus-send --print-reply --system --dest=com.nokia.icd2 /com/nokia/icd2 com.nokia.icd2.state_req |grep uint32 |sed "s:^.*uint32 ::"`
	if [ "$WIFI" = "0" ]; then
		echo "Connecting WiFi for you, try again in a few seconds"
		# auto-connect wifi
		run-standalone.sh /usr/bin/dbus-send --system --type=method_call --dest=com.nokia.icd /com/nokia/icd com.nokia.icd.connect string:"[ANY]" uint32:0
		exit 1
	fi
}
asui_download()
{
	echo "Downloading the $1 binary..."
	if [ "$1" = "statusbar-applet-test" ]; then
		maemo-mini-curl -o /root/${1}.tar.gz http://asui.garage.maemo.org/_download/${1}.tar.gz || exit
		mkdir /root/asui-tmp
		cd /root/asui-tmp
		tar zxvf /root/${1}.tar.gz
		cp usr/lib/hildon-desktop/libasui-* /usr/lib/hildon-desktop/
		cp usr/share/applications/hildon-status-bar/asui-* /usr/share/applications/hildon-status-bar/
		cp usr/share/icons/hicolor/40x40/hildon/asui_* /usr/share/icons/hicolor/40x40/hildon/
		chmod 644 /usr/lib/hildon-desktop/libasui-* /usr/share/applications/hildon-status-bar/asui-* /usr/share/icons/hicolor/40x40/hildon/asui_*
		cd ..
		rm -rf /root/${1}.tar.gz /root/asui-tmp
		echo "Updating icon cache, this will take a minute..."
		gtk-update-icon-cache -f /usr/share/icons/hicolor
	elif [ "$1" = "asui-settings-test" ]; then
		maemo-mini-curl -o /root/.$1 http://asui.garage.maemo.org/_download/asui-settings-test || exit
		chmod 755 /root/.$1
	else
		maemo-mini-curl -o /root/.advanced-systemui-$1 http://asui.garage.maemo.org/_download/advanced-systemui-$1 || exit
		chmod 755 /root/.advanced-systemui-$1
	fi
}
stop_systemui()
{
	if pidof systemui > /dev/null; then
		echo "SystemUI is running - stopping it..."
		/etc/init.d/osso-systemui stop || exit $?
	fi
}
case $1 in
	show)
		run-standalone.sh /usr/bin/dbus-send --system --type=method_call --dest=com.qzx.asui /com/qzx/asui com.qzx.asui.show
		;;
	hide)
		run-standalone.sh /usr/bin/dbus-send --system --type=method_call --dest=com.qzx.asui /com/qzx/asui com.qzx.asui.hide
		;;
	left)
		run-standalone.sh /usr/bin/dbus-send --system --type=method_call --dest=com.qzx.asui /com/qzx/asui com.qzx.asui.rotate_left
		;;
	right)
		run-standalone.sh /usr/bin/dbus-send --system --type=method_call --dest=com.qzx.asui /com/qzx/asui com.qzx.asui.rotate_right
		;;
	reload)
		run-standalone.sh /usr/bin/dbus-send --system --type=method_call --dest=com.qzx.asui /com/qzx/asui com.qzx.asui.reload_config
		;;
	s)
		/etc/init.d/advanced-systemui start
		;;
	k)
		/etc/init.d/advanced-systemui stop
		;;
	dt)
		asui_connect
		asui_download test
		;;
	rt)
		if [ -e /root/.advanced-systemui-test ]; then
			stop_systemui
			run-standalone.sh /root/.advanced-systemui-test
		else
			echo "You must first run 'asui dt' to download the test binary"
		fi
		;;
	it)
		if [ -e /root/.advanced-systemui-test ]; then
			if [ ! -e /root/.advanced-systemui-release ]; then
				echo "Saving the release binary..."
				cp /usr/bin/advanced-systemui /root/.advanced-systemui-release
			fi
			/etc/init.d/advanced-systemui stop
			echo "Using test binary for the service..."
			cp /root/.advanced-systemui-test /usr/bin/advanced-systemui
			/etc/init.d/advanced-systemui start
		else
			echo "You must first run 'asui dt' to download the test binary"
		fi
		;;
	dd)
		asui_connect
		asui_download debug
		;;
	rd)
		if [ -e /root/.advanced-systemui-debug ]; then
			stop_systemui
			run-standalone.sh /root/.advanced-systemui-debug
		else
			echo "You must first run 'asui dd' to download the debug binary"
		fi
		;;
	id)
		if [ -e /root/.advanced-systemui-debug ]; then
			if [ ! -e /root/.advanced-systemui-release ]; then
				echo "Saving the release binary..."
				cp /usr/bin/advanced-systemui /root/.advanced-systemui-release
			fi
			/etc/init.d/advanced-systemui stop
			echo "Using debug binary for the service..."
			cp /root/.advanced-systemui-debug /usr/bin/advanced-systemui
			/etc/init.d/advanced-systemui start
		else
			echo "You must first run 'asui dd' to download the debug binary"
		fi
		;;
	ds)
		asui_connect
		asui_download asui-settings-test
		;;
	rs)
		if [ -e /root/.asui-settings-test ]; then
			run-standalone.sh /root/.asui-settings-test
		else
			echo "You must first run 'asui ds' to download the asui-settings test binary"
		fi
		;;
	is)
		if [ -e /root/.asui-settings-test ]; then
			if [ ! -e /root/.asui-settings-release ]; then
				echo "Saving the asui-settings release binary..."
				cp /usr/bin/advanced-systemui-settings /root/.asui-settings-release
			fi
			echo "Installing the asui-settings test binary..."
			cp /root/.asui-settings-test /usr/bin/advanced-systemui-settings
			echo "Purging the asui-settings test binary..."
			rm -f /root/.asui-settings-test
		else
			echo "You must first run 'asui das' to download the asui-settings test binary"
		fi
		;;
	ps)
		if [ -e /root/.asui-settings-test ]; then
			echo "Purging the asui-settings test binary..."
			rm -f /root/.asui-settings-test
		else
			echo "Nothing to purge"
		fi
		;;
	da)
		asui_connect
		asui_download statusbar-applet-test
		echo "You will need to manually restart the desktop or the applets when upgrading"
		;;
	r)
		if [ -e /root/.advanced-systemui-release ]; then
			/etc/init.d/advanced-systemui stop
			echo "Restoring the release binary..."
			mv /root/.advanced-systemui-release /usr/bin/advanced-systemui
			/etc/init.d/advanced-systemui start
		else
			echo "There is no saved release binary to restore"
		fi
		;;
	u)
		asui_connect
		apt-get update
		apt-get install advanced-systemui
		;;
	uu)
		asui_connect
		echo "Downloading the latest asui script..."
		maemo-mini-curl -o /root/asui.sh http://asui.garage.maemo.org/_download/asui.sh || exit
		chmod 755 /root/asui.sh
		mv /root/asui.sh /usr/bin/asui
		;;
	*)
		echo "Syntax: asui <command>"
		echo " show : map ASUI window"
		echo " hide : unmap ASUI window"
		echo " left : rotate screen left"
		echo "right : rotate screen right"
		echo "reload : reload ASUI config"
		echo
		echo "   s  : start the service"
		echo "   k  : stop the service (kill)"
		echo
		echo "   dt : download the latest test binary"
		echo "   rt : run the test binary"
		echo "   it : install the test binary (this will start and stop the service)"
		echo
		echo "   dd : download the latest debug binary"
		echo "   rd : run the debug binary"
		echo "   id : install the debug binary (this will start and stop the service)"
		echo
		echo "   ds : download the latest asui-settings test binary"
		echo "   rs : run the asui-settings test binary"
		echo "   is : install the asui-settings test binary (close it before doing this)"
		echo "   ps : purge the asui-settings test binary"
		echo
		echo "   da : download and install the latest statusbar test applets"
		echo
		echo "   r  : restore the last release binary (this will start and stop the service)"
		echo "   u  : upgrade binary to the latest stable release package"
		echo "   uu : upgrade this script to latest test release"
esac
