#!/bin/sh

#QZX="linode"
QZX="qzx"

cd /opt/scratchbox/users/test/home/test/advanced-systemui/

function echo_msg(){
	echo -e "\033[36;2m$1\033[0m"
}

function rsync_command() {
	# 2>&1
	EXCLUDES="" ; [ -f ".excludes" ] && EXCLUDES="--exclude-from=.excludes --exclude=.excludes"
	rsync -lrtvz $EXCLUDES $* 2>&1 \
		|grep -v "^building file list" |grep -v "^receiving file list" |grep -v "^sent " |grep -v "^total size is" |grep -v "^$" |grep -v "^[.]/$" \
		|grep -v "^wrote " |grep -v "sending incremental file list" |grep -v "is not a tty"
#		|awk '{if(n==2) printf("  %s\n", $0); if($0=="-----------------------------------------------------------------------------") n+=1}'
}
function rsync_check() {
	# 2>&1
	EXCLUDES="" ; [ -f ".excludes" ] && EXCLUDES="--exclude-from=.excludes --exclude=.excludes"
	rsync --dry-run -lrtvz $EXCLUDES $* 2>&1 \
		|grep -v "^building file list" |grep -v "^receiving file list" |grep -v "^sent " |grep -v "^total size is" |grep -v "^$" |grep -v "^[.]/$" \
		|grep -v "^wrote " |grep -v "sending incremental file list" |grep -v "is not a tty"
#		|awk '{if(n==2) printf("  %s\n", $0); if($0=="-----------------------------------------------------------------------------") n+=1}'
}

#if [ "$1" = "upload" ]; then
#	echo_msg "uploading files to QZx..."
#	rsync_command ./ $QZX:www/tmp/advanced-systemui/
#elif [ "$1" = "check" ]; then
#	echo_msg "comparing files with QZx..."
#	rsync_check ./ $QZX:www/tmp/advanced-systemui/
#el
if [ "$1" = "tar" ]; then
	cd ..
	tar -X advanced-systemui/.excludes-tar -jcvf advanced-systemui.tar.bz2 advanced-systemui/
	echo_msg "Moving source code to web directory for upload..."
	install -o asd -g apache -m 640 advanced-systemui.tar.bz2 /home/http/html/asui/_download/
elif [ "$1" = "deb" ]; then
	cd ..
	echo_msg "Moving deb file to tmp repo..."
	mv advanced-systemui_*_armel.deb repo/dists/diablo/free/binary-armel/advanced-systemui/
	echo_msg "cd ../repo ; dpkg-scanpackages dists/diablo/free/binary-armel /dev/null | gzip -9c > dists/diablo/free/binary-armel/Packages.gz ; cd ../advanced-systemui"
elif [ "$1" = "repo" ]; then
	cd ..
	echo_msg "Moving deb file to repo..."
	install -o asd -g apache -m 640 repo/dists/diablo/free/binary-armel/Packages.gz /home/http/html/asui/repo/dists/diablo/free/binary-armel/
	install -o asd -g apache -m 640 repo/dists/diablo/free/binary-armel/advanced-systemui/*.deb /home/http/html/asui/repo/dists/diablo/free/binary-armel/advanced-systemui
	rm -f repo/dists/diablo/free/binary-armel/advanced-systemui/*.deb
	echo_msg "Now go upload the main website to sync tarball to QZx"
elif [ "$1" = "web" ]; then
	echo_msg "Moving asui script to web directory for upload..."
	install -o asd -g apache -m 640 asui.sh /home/http/html/asui/_download/
	if [ -f "advanced-systemui-test" ]; then
		echo_msg "Moving test binary to web directory for upload..."
		install -o asd -g apache -m 640 advanced-systemui-test /home/http/html/asui/_download/
	fi
	if [ -f "advanced-systemui-debug" ]; then
		echo_msg "Moving debug binary to web directory for upload..."
		install -o asd -g apache -m 640 advanced-systemui-debug /home/http/html/asui/_download/
	fi
	if [ -f "gtk-settings/advanced-systemui-settings" ]; then
		echo_msg "Moving asui-settings test binary to web directory for upload..."
		install -o asd -g apache -m 640 gtk-settings/advanced-systemui-settings /home/http/html/asui/_download/asui-settings-test
	fi
elif [ "$1" = "n810" ]; then
	echo_msg "Transfering asui script to n810..."
	scp asui.sh n810:/usr/bin/asui
	if [ -f "advanced-systemui-test" ]; then
		echo_msg "Transfering test binary to n810..."
		scp advanced-systemui-test n810:/root/.advanced-systemui-test
		ssh n810 chmod 755 /root/.advanced-systemui-test
	fi
	if [ -f "advanced-systemui-debug" ]; then
		echo_msg "Transfering debug binary to n810..."
		scp advanced-systemui-debug n810:/root/.advanced-systemui-debug
		ssh n810 chmod 755 /root/.advanced-systemui-debug
	fi
	if [ -f "gtk-settings/advanced-systemui-settings" ]; then
		echo_msg "Transfering asui-settings test binary to n810..."
		scp gtk-settings/advanced-systemui-settings n810:/root/.asui-settings-test
		ssh n810 chmod 755 /root/.asui-settings-test
	fi
elif [ "$1" = "sb" ]; then
	echo_msg "Transfering statusbar applets to n810..."
	scp statusbar/asui-*.desktop n810:/usr/share/applications/hildon-status-bar/
	scp statusbar/libasui-*.so n810:/usr/lib/hildon-desktop/
	ssh n810 chmod 644 /usr/lib/hildon-desktop/libasui-*.so /usr/share/applications/hildon-status-bar/asui-*.desktop
elif [ "$1" = "rmsb" ]; then
	echo_msg "Removing statusbar applets from n810..."
	ssh n810 rm /usr/lib/hildon-desktop/libasui-*.so /usr/share/applications/hildon-status-bar/asui-*.desktop
elif [ "$1" = "icons" ]; then
	echo_msg "Transfering statusbar icons to n810..."
	scp statusbar/icons/* n810:/usr/share/icons/hicolor/40x40/hildon/
	ssh n810 gtk-update-icon-cache -f /usr/share/icons/hicolor
elif [ "$1" = "getsb" ]; then
	echo_msg "Downloading statusbar-applet-test from n810..."
	scp n810:/root/statusbar-applet-test.tar.gz /home/http/html/asui/_download/
	chmod 640 /home/http/html/asui/_download/statusbar-applet-test.tar.gz
	chown asd.apache /home/http/html/asui/_download/statusbar-applet-test.tar.gz
else
	echo "Syntax: $0 <upload/check/tar/deb/repo/web/n810/sb/rmsb/icons/getsb>"
fi
