//	Advanced System UI
//	Copyright (c) 2011 Brand Huntsman <brand.huntsman@gmail.com>

//////////////////////////////////////////////////////////////////////////

GtkWidget *clock_ampm, *popup_onmap, *popup_fullscreen;

void toggle_checkbox_clock_24h( GtkToggleButton *widget, gpointer data ){
	unsigned state = (gtk_toggle_button_get_active(widget) == TRUE ? 1 : 0);
	conf_set_bool((const char *)data, state);
	gtk_widget_set_sensitive(clock_ampm, (state ? FALSE : TRUE));
}

void change_popup_duration( GObject *gobject, GParamSpec *arg1, gpointer user_data ){
	if(strcmp(arg1->name, "value")) return;
	int value;
	g_object_get(gobject, "value", &value, NULL);
	if(value >= 0){
		conf_set_int((const char *)user_data, value);
		gtk_widget_set_sensitive(popup_onmap, (value > 0 ? TRUE : FALSE));
		gtk_widget_set_sensitive(popup_fullscreen, (value > 0 ? TRUE : FALSE));
	}
}

//////////////////////////////////////////////////////////////////////////

void clock_click_callback( GtkWidget *widget, gpointer data ){
	new_section_vbox("Clock"); // add setting widgets to section_content_box

	GtkWidget *clock_24h = new_checkbox(conf_clock_24h, "display 24 hour clock (else 12 hour)", toggle_checkbox_clock_24h);

	new_separator();

	clock_ampm = new_checkbox(conf_clock_ampm, "display AM/PM indicator [12 hour clock only]", NULL);
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(clock_24h)))
		gtk_widget_set_sensitive(clock_ampm, FALSE); // disable when 24h clock

	new_separator();

	new_message("A popup with battery status and clock can be shown each time screen turns on. Setting duration to zero will disable the popup.");
	new_uint_value(conf_popup_duration, "popup duration (seconds)", 15, change_popup_duration);

	popup_onmap = new_checkbox(conf_popup_onmap, "show popup when mapping ASUI", NULL);
	popup_fullscreen = new_checkbox(conf_popup_fullscreen, "fullscreen popup", NULL);
	if(conf_get_int(conf_popup_duration) == 0){
		gtk_widget_set_sensitive(popup_onmap, FALSE); // disable when duration is zero
		gtk_widget_set_sensitive(popup_fullscreen, FALSE); // disable when duration is zero
	}

	new_separator();
}
