#define _WINDOW_H_

#include <X11/Xlib.h>

typedef enum e_orientation { O_LANDSCAPE, O_PORTRAIT, O_LANDSCAPE_INV, O_PORTRAIT_INV } e_orientation;

typedef struct s_window {
	Display *display;
	Window root_window;
	int screen;
	Visual *visual;
	int depth;
	Colormap colormap;
	unsigned width, height;
	Window window;
	GC gc;
	unsigned is_mapped;
	unsigned supports_rotation, xrr_event_base;
	e_orientation orientation;
	unsigned has_focus;
} s_window;

extern s_window window;

extern XColor *bg_color, *line_color, *innerline_color, *fg1_color, *fg2_color, *white_color, *rotation_color;
extern XColor *gray_status_color, *yellow_status_color, *green_status_color, *red_status_color;
extern XColor *scrollbar_color, *scroller_color, *selection_color, *secondary_selection_color;

typedef struct s_image {
	Pixmap black_pixmap, white_pixmap, mask;
	unsigned width, height;
} s_image;

extern s_image im_toflight, im_tonormal, im_reboot, im_shutdown, im_portrait, im_portrait_inv, im_landscape_inv;
extern s_image im_volume, im_brightness;

extern unsigned black_theme;

extern unsigned blank_window_open;
extern int blank_fd;

//////////////////////////////////////////////////////////////////////////

int window_init( );

void window_set_theme( unsigned white_theme );
void window_auto_set_theme( unsigned initialize );

void window_map( );
void window_unmap( );

void window_close( unsigned terminate );

void rotate_screen( e_orientation new_orientation, unsigned keep_mapped );
void update_orientation( XEvent *event );
int check_orientation( );

void window_open_blank( );
void window_close_blank( );
unsigned window_blank_events( );

#define x_set_color(color) XSetForeground(window.display, window.gc, color->pixel)
#define x_set_style(width, style) XSetLineAttributes(window.display, window.gc, width, style, CapButt, JoinMiter)
#define x_reset_style() XSetLineAttributes(window.display, window.gc, 1, LineSolid, CapButt, JoinMiter)
#define x_draw_point(x, y) XDrawPoint(window.display, window.window, window.gc, x, y)
#define x_draw_line(x1, y1, x2, y2) XDrawLine(window.display, window.window, window.gc, x1, y1, x2, y2)
#define x_draw_rectangle(x, y, w, h) XDrawRectangle(window.display, window.window, window.gc, x, y, w, h)
#define x_fill_rectangle(x, y, w, h) XFillRectangle(window.display, window.window, window.gc, x, y, w, h)
#define x_fill_ellipse(x, y, w, h) XFillArc(window.display, window.window, window.gc, x, y, w, h, 0, 360*64)
#define x_flush() XFlush(window.display)
