//	Advanced System UI
//	Copyright (c) 2010 Brand Huntsman <http://qzx.com/mail/>

#include <stdio.h>

#include "window.h"
#include "main.h"
#include "draw.h"
#include "text.h"
#include "config.h"
#include "services.h"

//////////////////////////////////////////////////////////////////////////

void draw_ssh_widget( unsigned force, int x, int y ){
	if(force){
		// background for all widgets is cleared by draw_window()
	} else if(svc_changes & SVC_SSH){
		// widget background
		x_set_color(bg_color);
		x_fill_rectangle(x, y, 199, 99);
	} else return;

	draw_text((cfg_ssh_server == SSH_SERVER_OPENSSH ? "OpenSSH" : "Dropbear"), 28, fg2_color, x+99, y+20, ALIGN_CENTER, ALIGN_TOP, 0);
	if(svc_ssh_installed){
		draw_services_indicator(svc_ssh_status, x+99, y+70, 50);
		draw_rss(svc_ssh_size, x+190, y+90);
		if(svc_ssh_nr_clients){
			char buffer[15];
			snprintf(buffer, sizeof(buffer), "%u client%s", svc_ssh_nr_clients, (svc_ssh_nr_clients > 1 ? "s" : ""));
			draw_text(buffer, 14, fg1_color, x+10, y+90, ALIGN_LEFT, ALIGN_BOTTOM, 0);
		}

		draw_tap_markers(x, y, 99, 1, 1); // short and long taps
	} else {
		draw_text("not installed", 16, fg2_color, x+99, y+65, ALIGN_CENTER, ALIGN_MIDDLE, 0);

		draw_tap_markers(x, y, 99, 0, 1); // long tap only
	}
}

//////////////////////////////////////////////////////////////////////////

static s_tap_throttler ssh_throttle;

void click_ssh_widget( ){
	if(click.type == CLICK_HOLD){

		// highlight to indicate long press
		highlight_long_press(widget_x, widget_y, 199, 99);

	} else if(click.type == CLICK_LONG){

		highlight_selected_area(widget_x, widget_y, 199, 99);

		// cycle ssh visible server
		cfg_ssh_server++;
		svc_refresh();
		conf_set_int(conf_ssh_server, cfg_ssh_server);

		svc_changes |= SVC_SSH;
		draw_ssh_widget(0, widget_x, widget_y);

	} else if(svc_ssh_installed){

		if(click.type != CLICK_SHORT) return; // no long press or drag support

		// require double tap if enabled
		if(!get_double_tap(Z_MAIN_SVC_SSH)) return;

		if(throttle_taps(&ssh_throttle)) return;

		{
			highlight_selected_area(widget_x, widget_y, 199, 99);

			if(svc_ssh_status){
				// get correct number of clients
				if(cfg_ssh_server == SSH_SERVER_DROPBEAR) svc_refresh();

				// don't stop dropbear if clients connected, it can't distinguish between clients and server and the service light will stay on until all clients disconnect
				if(!(cfg_ssh_server == SSH_SERVER_DROPBEAR && svc_ssh_nr_clients))
					svc_init_ssh(SVC_STOP, 0);
			} else
				svc_init_ssh(SVC_START, 0);

			svc_changes |= SVC_SSH;
			draw_ssh_widget(0, widget_x, widget_y); // update service dot
		}

		finalize_tap(ssh_throttle);

	}
}

////////////////////////////////////////////////////////////////////////// WIDGET

s_widget widget_ssh = {"SSH", "/apps/asui_state/cell_ssh", HALF_WIDGET, draw_ssh_widget, click_ssh_widget, 0};
