//	Advanced System UI
//	Copyright (c) 2010 Brand Huntsman <http://qzx.com/mail/>

#include "window.h"
#include "main.h"
#include "draw.h"
#include "text.h"
#include "config.h"
#include "services.h"

//////////////////////////////////////////////////////////////////////////

void draw_desktop_widget( unsigned force, int x, int y ){
	if(force){
		// background for all widgets is cleared by draw_window()
	} else if(svc_changes & SVC_DESKTOP){
		// widget background
		x_set_color(bg_color);
		x_fill_rectangle(x, y, 199, 99);
	} else return;

	draw_text("Desktop", 28, fg2_color, x+99, y+20, ALIGN_CENTER, ALIGN_TOP, 0);
	draw_services_indicator(svc_desktop_status, x+99, y+70, 50);
	draw_rss(svc_desktop_size, x+190, y+90);

	draw_tap_markers(x, y, 99, 1, 0); // short tap only
}

//////////////////////////////////////////////////////////////////////////

static s_tap_throttler desktop_throttle;

void click_desktop_widget( ){
	if(click.type != CLICK_SHORT) return; // no long press or drag support

	// require double tap if enabled
	if(!get_double_tap(Z_MAIN_SVC_DESKTOP)) return;

	if(throttle_taps(&desktop_throttle)) return;

	{
		highlight_selected_area(widget_x, widget_y, 199, 99);

		// toggling freezes client momentarily, display ticks
		init_ticks(widget_x+42, widget_y+50, gray_status_color);

		if(svc_desktop_status)
			svc_init_desktop(SVC_STOP, 1); // display ticks
		else
			svc_init_desktop(SVC_START, 1); // display ticks

		svc_changes |= SVC_DESKTOP;
		draw_desktop_widget(0, widget_x, widget_y); // update service dot
	}

	finalize_tap(desktop_throttle);
}

////////////////////////////////////////////////////////////////////////// WIDGET

s_widget widget_desktop = {"Desktop", "/apps/asui_state/cell_desktop", HALF_WIDGET, draw_desktop_widget, click_desktop_widget, 0};
