//	Advanced System UI
//	Copyright (c) 2010 Brand Huntsman <http://qzx.com/mail/>

// seconds (double)
#define SLIDER_UPDATE_PERIOD 0.500

#include <stdio.h>
#include <unistd.h>

#include "window.h"
#include "main.h"
#include "draw.h"
#include "text.h"
#include "config.h"
#include "hardware.h"

#include "widget_brightness.h"

//////////////////////////////////////////////////////////////////////////

static int brightness_widget_x, brightness_widget_y; // save position for set_brightness()

void draw_brightness_widget( unsigned force, int x, int y ){
	if(force){
		// background for all widgets is cleared by draw_window()
		brightness_widget_page = primary_widgets;
		brightness_widget_x = x;
		brightness_widget_y = y;
	} else if(hw_changes & (HW_BRIGHTNESS|HW_LIGHT)){
		x = brightness_widget_x;
		y = brightness_widget_y;
		// widget background
		x_set_color(bg_color);
		x_fill_rectangle(x, y, 399, 99);
	} else return;

	// slider
	draw_scrollbar(&im_brightness, x, y, hw_screen.brightness_level, (cfg_brightness_allow_zero ? 0 : 1), hw_screen.brightness_max);
	draw_step_buttons(x, y, hw_screen.brightness_level > (cfg_brightness_allow_zero ? 0 : 1), hw_screen.brightness_level < hw_screen.brightness_max);
	// value
	char value[4];
	snprintf(value, sizeof(value), "%d", hw_screen.brightness_level);

	// dimmed status or previous value
	if(hw_screen.dimmed){
		draw_text(value, 16, fg1_color, x+199, y+60, ALIGN_CENTER, ALIGN_TOP, 0);
		draw_text("dimmed", 10, white_color, x+199, y+80, ALIGN_CENTER, ALIGN_TOP, 0);
	} else if(cfg_brightness_enhanced && hw_screen.brightness_current != hw_screen.brightness_level){
		draw_text(value, 16, fg1_color, x+199, y+60, ALIGN_CENTER, ALIGN_TOP, 0);

		char buffer[20];
		snprintf(buffer, sizeof(buffer), "%u", hw_screen.brightness_current);
		draw_text(buffer, 14, selection_color, x+199, y+80, ALIGN_CENTER, ALIGN_TOP, 0);
	} else
		draw_text(value, 16, fg1_color, x+199, y+78, ALIGN_CENTER, ALIGN_MIDDLE, 0);

	// theme button
	x_set_color(innerline_color);
	x_set_style(1, LineOnOffDash); // dotted line
	x_draw_line(x+292,y+55, x+399,y+55); // top
	x_draw_line(x+292,y+55, x+292,y+99); // left vertical
	x_reset_style();

	// theme changer button and ambient light value
	if(is_810){
		char buffer[20];

		// ambient light value
		snprintf(buffer, sizeof(buffer), "%d lux", hw_sensors.light);
		int w = draw_text(buffer, 16, fg2_color, x+345, y+78, ALIGN_CENTER, ALIGN_MIDDLE, 105) >> 1;

		// ALS theme override indicator
		if(cfg_theme && !cfg_short_tap_markers){
			x_set_color(selection_color);
			x_draw_line(x+345-w, y+86, x+345+w, y+86);
		}

		draw_tap_markers(x+293, y+56, 43, cfg_theme, 1); // long tap, short tap only if ALS theme is disabled
	} else {
		// selected theme
		draw_text((black_theme ? "white" : "black"), 16, line_color, x+345, y+78, ALIGN_CENTER, ALIGN_MIDDLE, 0);

		draw_tap_markers(x+293, y+56, 43, 1, 0); // short tap only
	}
}

//////////////////////////////////////////////////////////////////////////

static void redraw_brightness_widget( ){
	hw_changes |= HW_BRIGHTNESS; // force redraw
	draw_brightness_widget(0, 0, 0);
	hw_changes &= ~HW_BRIGHTNESS; // reset flag
	x_flush();
}

void set_brightness( unsigned level ){
	hw_set_brightness(level, 1);

	redraw_brightness_widget();
}

static void decrement_brightness( ){
	if(hw_screen.brightness_level > (cfg_brightness_allow_zero ? 0 : 1))
		set_brightness(hw_screen.brightness_level-1);
	else
		button_callback = NULL;
}

static void increment_brightness( ){
	if(hw_screen.brightness_level < hw_screen.brightness_max)
		set_brightness(hw_screen.brightness_level+1);
	else
		button_callback = NULL;
}

static unsigned update_slider( ){
	if(click.y + click.offset_y <= 55){
		unsigned position = click_scrollbar(click.x + click.offset_x, (cfg_brightness_allow_zero ? 0 : 1), hw_screen.brightness_max);

		if(position != hw_screen.brightness_level){
			set_brightness(position);
			return 1; // motion timer is reset by main loop
		}
	}

	return 0;
}

void click_brightness_widget( ){
	if(click.y > 55){

		if(click.x < 50){

			// STEP DOWN BUTTON

			if(click.type == CLICK_DOWN){

				if(hw_screen.brightness_level > (cfg_brightness_allow_zero ? 0 : 1)){
					button_autorepeat = 1;
					button_callback = decrement_brightness;
				}

			} else if(click.type == CLICK_SHORT || click.type == CLICK_LONG || click.type == CLICK_DRAG){

				if(click.type == CLICK_SHORT)
					decrement_brightness();

				button_callback = NULL;

			} // ignore motion and hold

		} else if(click.x < 100){

			// STEP UP BUTTON

			if(click.type == CLICK_DOWN){

				if(hw_screen.brightness_level < hw_screen.brightness_max){
					button_autorepeat = 1;
					button_callback = increment_brightness;
				}

			} else if(click.type == CLICK_SHORT || click.type == CLICK_LONG || click.type == CLICK_DRAG){

				if(click.type == CLICK_SHORT)
					increment_brightness();

				button_callback = NULL;

			} // ignore motion and hold

		} else if(click.x > 292){

			// THEME BUTTON

			if(click.type == CLICK_HOLD && is_810){

				// highlight to indicate long press
				highlight_long_press(widget_x+293, widget_y+56, 106, 43);

			} else if(click.type == CLICK_LONG && is_810){

				highlight_selected_area(widget_x+293, widget_y+56, 106, 43);

				if(cfg_theme){
					// switch to ALS theme
					cfg_theme = 0;
					conf_set_int(conf_theme, 0);
					// change theme if ALS is different
					window_auto_set_theme(0);
					if(hw_changes & HW_THEME)
						draw_window(1);
					else
						redraw_brightness_widget();
				} else {
					// switch to manual theme (this will never cause a theme change)
					cfg_theme = (black_theme ? 1 : 2);
					conf_set_int(conf_theme, cfg_theme);
					redraw_brightness_widget();
				}

			} else if(click.type == CLICK_SHORT && cfg_theme){

				highlight_selected_area(widget_x+293, widget_y+56, 106, 43);

				cfg_theme = (cfg_theme == 1 ? 2 : 1);
				conf_set_int(conf_theme, cfg_theme);

				window_set_theme(cfg_theme - 1);
				draw_window(1);

			} // ignore motion and drag

		}

	} else {

		// SLIDER

		if(click.type == CLICK_DOWN){

			update_slider();

			motion_callback = update_slider;
			set_timer(&motion_timer, SLIDER_UPDATE_PERIOD);

		} else if(click.type == CLICK_SHORT || click.type == CLICK_DRAG || click.type == CLICK_LONG){

			update_slider();

			motion_callback = NULL;

		}
	}
}

////////////////////////////////////////////////////////////////////////// WIDGET

s_widget widget_brightness = {"Brightness", "/apps/asui_state/cell_brightness", FULL_WIDGET, draw_brightness_widget, click_brightness_widget, 0};
