//	Advanced System UI
//	Copyright (c) 2010 Brand Huntsman <http://qzx.com/mail/>

#include "window.h"
#include "main.h"
#include "draw.h"
#include "text.h"
#include "config.h"
#include "services.h"

//////////////////////////////////////////////////////////////////////////

void draw_audio_widget( unsigned force, int x, int y ){
	if(force){
		// background for all widgets is cleared by draw_window()
	} else if(svc_changes & SVC_AUDIO){
		// widget background
		x_set_color(bg_color);
		x_fill_rectangle(x, y, 199, 99);
	} else return;

	draw_text("Audio", 28, fg2_color, x+99, y+20, ALIGN_CENTER, ALIGN_TOP, 0);
	draw_services_indicator(svc_audio_status, x+99, y+70, 50);
	draw_rss(svc_audio_size, x+190, y+90);

	draw_tap_markers(x, y, 99, 1, 0); // short tap only
}

//////////////////////////////////////////////////////////////////////////

static s_tap_throttler audio_throttle;

void click_audio_widget( ){
	if(click.type != CLICK_SHORT) return; // no long press or drag support

	// require double tap if enabled and service is fully started or stopped
	// partial state always uses a single tap
	if(svc_audio_status != 1)
		if(!get_double_tap(Z_MAIN_SVC_AUDIO)) return;

	if(throttle_taps(&audio_throttle)) return;

	{
		if(svc_audio_status == 1 && click.x >= 100){
			highlight_selected_area(widget_x+100, widget_y, 99, 99);
			svc_audio_status = 0; // attempt to start services
		} else
			highlight_selected_area(widget_x, widget_y, (svc_audio_status == 1 ? 99 : 199), 99);

		if(svc_audio_status)
			svc_init_audio(SVC_STOP);
		else
			svc_init_audio(SVC_START);

		svc_changes |= SVC_AUDIO;
		draw_audio_widget(0, widget_x, widget_y); // update service dot
	}

	finalize_tap(audio_throttle);
}

////////////////////////////////////////////////////////////////////////// WIDGET

s_widget widget_audio = {"Audio", "/apps/asui_state/cell_audio", HALF_WIDGET, draw_audio_widget, click_audio_widget, 0};
