//	Advanced System UI
//	Copyright (c) 2011 Brand Huntsman <http://qzx.com/mail/>

#define ASUI_VERSION "0.5.0"

/*
/etc/init.d/hildon-desktop stop
su - user -c "maemo-summoner /usr/bin/hildon-desktop.launch"
*/

#include <hildon/hildon-defines.h>
#include <libhildondesktop/libhildondesktop.h>
#include <libhildondesktop/statusbar-item.h>

#include <log-functions.h>
#include <libosso.h>
#include <osso-log.h>

#include <dbus/dbus.h>

#include <glib.h>
#include <gtk/gtk.h>
#include <gdk/gdkpixbuf.h>

//////////////////////////////////////////////////////////////////////////

G_BEGIN_DECLS

typedef struct _AsuiPowerPlugin AsuiPowerPlugin;
typedef struct _AsuiPowerPluginClass AsuiPowerPluginClass;

#define ASUI_POWER_PLUGIN_PRIORITY 1

#define ASUI_POWER_PLUGIN_ICON_SIZE 40

#define ASUI_POWER_PLUGIN_TYPE				(asui_power_plugin_get_type())
#define ASUI_POWER_PLUGIN(obj)				(G_TYPE_CHECK_INSTANCE_CAST((obj),	ASUI_POWER_PLUGIN_TYPE, AsuiPowerPlugin))
#define ASUI_POWER_PLUGIN_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass),	ASUI_POWER_PLUGIN_TYPE, AsuiPowerPluginClass))
#define IS_ASUI_POWER_PLUGIN(obj)			(G_TYPE_CHECK_INSTANCE_TYPE((obj),	ASUI_POWER_PLUGIN_TYPE))
#define IS_ASUI_POWER_PLUGIN_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass),	ASUI_POWER_PLUGIN_TYPE))
#define ASUI_POWER_PLUGIN_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj),	ASUI_POWER_PLUGIN_TYPE, AsuiPowerPluginClass))

struct _AsuiPowerPlugin { StatusbarItem parent; };
struct _AsuiPowerPluginClass { StatusbarItemClass parent_class; };

GType asui_power_plugin_get_type(void);

typedef struct {
	osso_context_t *osso; // osso
	DBusGConnection *connection; // system bus
	GtkWidget *icon; // icon in button
	GtkWidget *button; // button in statusbar
} AsuiPowerPluginPrivate;

G_END_DECLS

HD_DEFINE_PLUGIN(AsuiPowerPlugin, asui_power_plugin, STATUSBAR_TYPE_ITEM);

#define ASUI_POWER_PLUGIN_GET_PRIVATE(object) (G_TYPE_INSTANCE_GET_PRIVATE((object), ASUI_POWER_PLUGIN_TYPE, AsuiPowerPluginPrivate))

//////////////////////////////////////////////////////////////////////////

static void asui_power_plugin_finalize( GObject *object );

static void asui_power_plugin_class_init( AsuiPowerPluginClass *klass ){
	GObjectClass *object_class = G_OBJECT_CLASS(klass);
	object_class->finalize = asui_power_plugin_finalize;
	g_type_class_add_private(klass, sizeof(AsuiPowerPluginPrivate));
}

//////////////////////////////////////////////////////////////////////////

static void asui_power_set_icon( const gchar *name, AsuiPowerPluginPrivate *p ) {
	GtkIconTheme *icon_theme;
	GdkPixbuf*pixbuf;

	icon_theme = gtk_icon_theme_get_default();
	pixbuf = (name != NULL ? gtk_icon_theme_load_icon(icon_theme, name, ASUI_POWER_PLUGIN_ICON_SIZE, GTK_ICON_LOOKUP_NO_SVG, NULL) : NULL);
	gtk_image_set_from_pixbuf(GTK_IMAGE(p->icon), pixbuf);

	if(pixbuf != NULL) g_object_unref(pixbuf);
}

//////////////////////////////////////////////////////////////////////////

static void asui_power_dbus_map_asui( AsuiPowerPluginPrivate *p ){
	DBusConnection *system_bus = dbus_g_connection_get_connection(p->connection);
	DBusMessage *message = dbus_message_new_method_call("com.qzx.asui", "/com/qzx/asui", "com.qzx.asui", "show");
	if(dbus_connection_send(system_bus, message, NULL) != FALSE)
		dbus_connection_flush(system_bus);
	dbus_message_unref(message);
}

static gboolean asui_power_reset_press( gpointer data ){
	asui_power_set_icon("asui_power", (AsuiPowerPluginPrivate *)data);
	return FALSE;
}

static gboolean asui_power_open_asui( GtkButton *widget, GdkEventButton *button, gpointer data ){
	AsuiPowerPluginPrivate *p = (AsuiPowerPluginPrivate *)data;

	g_return_val_if_fail(data, FALSE);
	gtk_button_released(GTK_BUTTON(p->button));
	(void) button;

	asui_power_dbus_map_asui(p);

	asui_power_set_icon("asui_power_pressed", p);
	g_timeout_add(1000, asui_power_reset_press, (void *)p);

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////

static void asui_power_plugin_finalize( GObject *object ){
	AsuiPowerPluginPrivate *p = ASUI_POWER_PLUGIN_GET_PRIVATE(object);
	dbus_g_connection_unref(p->connection);
	osso_deinitialize(p->osso);

	LOG_CLOSE();

	G_OBJECT_CLASS(g_type_class_peek_parent(G_OBJECT_GET_CLASS(object)))->finalize(object);
}

static void asui_power_plugin_init( AsuiPowerPlugin *plugin ){
	AsuiPowerPluginPrivate *p = ASUI_POWER_PLUGIN_GET_PRIVATE(plugin);

	ULOG_OPEN("asui-statusbar-power");

	g_return_if_fail(p);

	// initialize dbus
	GError *error = NULL;
	if((p->connection = dbus_g_bus_get(DBUS_BUS_SYSTEM, &error)) == NULL){
		ULOG_WARN("%s: can't connect to system method bus: %s\n", __FUNCTION__, error->message);
		g_error_free(error);
		return;
	}

	p->icon = gtk_image_new_from_pixbuf(NULL);
	asui_power_set_icon("asui_power", p);
	p->button = gtk_toggle_button_new();
	gtk_container_add(GTK_CONTAINER(p->button), GTK_WIDGET(p->icon));
	gtk_container_add(GTK_CONTAINER(plugin), p->button);
	g_signal_connect(G_OBJECT(p->button), "button-press-event", G_CALLBACK(asui_power_open_asui), p);

	// osso context
	p->osso = osso_initialize("com.qzx.asui_statusbar_power", ASUI_VERSION, TRUE, NULL);
	if(!p->osso) ULOG_WARN("%s: error while initializing osso\n", __FUNCTION__);

	gtk_widget_show_all(GTK_WIDGET(plugin));
}
