//	Advanced System UI
//	Copyright (c) 2011 Brand Huntsman <http://qzx.com/mail/>

//////////////////////////////////////////////////////////////////////////

void change_threshold_value( GObject *gobject, GParamSpec *arg1, gpointer user_data ){
	if(strcmp(arg1->name, "value")) return;
	int value;
	g_object_get(gobject, "value", &value, NULL);
	if(value >= 0) conf_set_int((const char *)user_data, value);
}
void new_threshold_value( const char *conf, char *name ){
	// hbox
	GtkWidget *hbox = gtk_hbox_new(FALSE, 10);
	gtk_box_pack_start(GTK_BOX(section_content_box), hbox, FALSE, FALSE, 10);
	gtk_widget_show(hbox);
	// numeric entry with arrows
	GtkWidget *editor = hildon_number_editor_new(0, 999999999);
	hildon_number_editor_set_value((HildonNumberEditor *)editor, conf_get_int(conf));
	gtk_signal_connect(GTK_OBJECT(editor), "notify", GTK_SIGNAL_FUNC(change_threshold_value), (void *)conf);
	gtk_box_pack_start(GTK_BOX(hbox), editor, FALSE, FALSE, 20);
	gtk_widget_show(editor);
	// label
	GtkWidget *label = gtk_label_new(name);
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
	gtk_widget_show(label);
}

//////////////////////////////////////////////////////////////////////////

void ui_click_callback( GtkWidget *widget, gpointer data ){
	new_section_vbox("User Interface"); // add setting widgets to section_content_box

	new_checkbox(conf_service_size_unit, "show \"MB\" after service size", NULL);

	new_separator();

	new_message("Orange long tap markers are always displayed");
	new_checkbox(conf_short_tap_markers, "show blue markers for buttons that support short taps", NULL);

	new_separator();

	new_checkbox(conf_start_visible, "show ASUI window at startup", NULL);

	new_separator();

	new_message("When ALS value exceeds the white threshold the white theme is activated and returns to black theme when value drops below the black threshold.");
	new_threshold_value(conf_threshold_black, "black threshold [n810 only]");
	new_threshold_value(conf_threshold_white, "white threshold [n810 only]");

	new_separator();
}
