//	Advanced System UI
//	Copyright (c) 2011 Brand Huntsman <http://qzx.com/mail/>

//////////////////////////////////////////////////////////////////////////

void toggle_boot_charger_checkbox( GtkToggleButton *widget, gpointer data ){
	if(gtk_toggle_button_get_active(widget) == TRUE)
		system("/bin/ln -sf ../init.d/advanced-systemui /etc/rc5.d/S99advanced-systemui"); // run in the boot charging runlevel
	else
		system("/bin/rm -f /etc/rc5.d/S99advanced-systemui"); // don't run
}
void toggle_shutdown_charger_checkbox( GtkToggleButton *widget, gpointer data ){
	if(gtk_toggle_button_get_active(widget) == TRUE)
		system("/bin/rm -f /etc/rc5.d/K99advanced-systemui"); // run in the shutdown charging runlevel
	else
		system("/bin/ln -sf ../init.d/advanced-systemui /etc/rc5.d/K99advanced-systemui"); // don't run
}
GtkWidget *new_system_checkbox( unsigned state, char *label, void (*callback)(GtkToggleButton *widget, gpointer data) ){
	GtkWidget *checkbox = gtk_check_button_new_with_label(label);
	gtk_signal_connect(GTK_OBJECT(checkbox), "toggled", GTK_SIGNAL_FUNC(callback), NULL);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbox), state);
	gtk_box_pack_start(GTK_BOX(section_content_box), checkbox, FALSE, FALSE, 10);
	gtk_widget_show(checkbox);
	return checkbox;
}

//////////////////////////////////////////////////////////////////////////

void system_click_callback( GtkWidget *widget, gpointer data ){
	new_section_vbox("System"); // add setting widgets to section_content_box

	new_message("The device code can be bypassed if ASUI is installed in the boot charging runlevel, disable if you use a code and care about this");
	new_system_checkbox(file_exists("/etc/rc5.d/S99advanced-systemui"), "show ASUI when device is off and placed on charger", toggle_boot_charger_checkbox);

	new_separator();

	new_message("Enabling this setting is safe and won't allow the device code to be bypassed");
	new_system_checkbox(!file_exists("/etc/rc5.d/K99advanced-systemui"), "show ASUI when shutdown while connected to charger", toggle_shutdown_charger_checkbox);

	new_separator();

// TODO: boolean to remove osso-systemui from boot scripts so system boots faster
new_message("...checkbox to disable osso-systemui at boot...");
//new_system_checkbox(conf_, "", NULL);

	new_separator();

// TODO: booleans to modify /etc/asui-svc to start systemui when ASUI stops
//		add a note to the file that is will be overwritten by asui-settings app
new_message("...checkboxes to modify /etc/asui-svc file...");
//new_system_checkbox(conf_, "", NULL);
//new_separator();
//new_system_checkbox(conf_, "", NULL);
/*
# stop systemui when starting asui?
SYSTEMUI_STOP=true

# start systemui when asui is stopped?
SYSTEMUI_START=true
*/

	new_separator();
}
