//	Advanced System UI
//	Copyright (c) 2011 Brand Huntsman <http://qzx.com/mail/>
//
//	device model detection code ported from advanced-backlight
//	(C) 2008 Jonas Hurrelmann <j@outpo.st>.
//	(C) 2008 Adam Harwell <aharwell@trinity.edu>.

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <dbus/dbus.h>
#include <gtk/gtk.h>
#include <hildon/hildon.h>
#include <dirent.h>
#include <gconf/gconf-client.h>

#define _STRING_ DBUS_TYPE_STRING
#define _BOOL_ DBUS_TYPE_BOOLEAN
#define _UINT32_ DBUS_TYPE_UINT32
#define _INT32_ DBUS_TYPE_INT32
#define _ARRAY_ DBUS_TYPE_ARRAY
//#define _VARIANT_ DBUS_TYPE_VARIANT
#define _END_ DBUS_TYPE_INVALID

//////////////////////////////////////////////////////////////////////////

unsigned is_770, is_800, is_810;

//////////////////////////////////////////////////////////////////////////

DBusConnection *system_bus;
DBusError dbus_error;

void asui_reload_settings( ){
	DBusMessage *message = dbus_message_new_method_call("com.qzx.asui", "/com/qzx/asui", "com.qzx.asui", "reload_config");
	dbus_message_set_no_reply(message, TRUE);
	if(dbus_connection_send(system_bus, message, NULL) != FALSE)
		dbus_connection_flush(system_bus);
	dbus_message_unref(message);
}

unsigned file_exists( const char *file ){
	if(access(file, R_OK)) return 0;
	return 1;
}

//////////////////////////////////////////////////////////////////////////

GConfClient *gconf_client;

#define conf_get_bool(key) gconf_client_get_bool(gconf_client, key, (GError **)NULL)
#define conf_get_int(key) gconf_client_get_int(gconf_client, key, (GError **)NULL)

#define conf_set_bool(key, value) {gconf_client_set_bool(gconf_client, key, value, (GError **)NULL); asui_reload_settings(); }
#define conf_set_int(key, value) {gconf_client_set_int(gconf_client, key, value, (GError **)NULL); asui_reload_settings(); }

// battery
static const char *conf_battery_idle_time = "/apps/asui/battery_idle_time";
static const char *conf_memory_format = "/apps/asui/memory_format";
static const char *conf_swap_format = "/apps/asui/swap_format";
static const char *conf_temperature_F = "/apps/asui/temperature_F";
// clock
static const char *conf_clock_24h = "/apps/asui/clock_24h";
static const char *conf_clock_ampm = "/apps/asui/clock_ampm";
// brightness
static const char *conf_brightness_enhanced = "/apps/asui/brightness_enhanced";
static const char *conf_brightness_allow_zero = "/apps/asui/brightness_allow_zero";
// RBV keys
static const char *conf_buttons_rotate = "/apps/asui/buttons_rotate";
static const char *conf_buttons_brightness = "/apps/asui/buttons_brightness";
static const char *conf_buttons_brightness_step = "/apps/asui/buttons_brightness_step";
static const char *conf_buttons_volume = "/apps/asui/buttons_volume";
static const char *conf_buttons_volume_step = "/apps/asui/buttons_volume_step";
// button modes
static const char *conf_double_tap = "/apps/asui/double_tap";
static const char *conf_lock_and_close = "/apps/asui/lock_and_close";
static const char *conf_n800_lock_mode = "/apps/asui/n800_lock_mode";
static const char *conf_rotate_and_close = "/apps/asui/rotate_and_close";
static const char *conf_buttons_dpad_short = "/apps/asui/buttons_dpad_short";
static const char *conf_buttons_dpad_long = "/apps/asui/buttons_dpad_long";
static const char *conf_buttons_lock1_short = "/apps/asui/buttons_lock1_short";
static const char *conf_buttons_lock1_long = "/apps/asui/buttons_lock1_long";
static const char *conf_buttons_lock2_short = "/apps/asui/buttons_lock2_short";
static const char *conf_buttons_lock2_long = "/apps/asui/buttons_lock2_long";
static const char *conf_secure_action = "/apps/asui/secure_action";
static const char *conf_secure_power_action = "/apps/asui/secure_power_action";
static const char *conf_secure_button = "/apps/asui/secure_button";
// user interface
static const char *conf_service_size_unit = "/apps/asui/service_size_unit";
static const char *conf_short_tap_markers = "/apps/asui/short_tap_markers";
static const char *conf_start_visible = "/apps/asui/start_visible";
static const char *conf_threshold_black = "/apps/asui/threshold_black";
static const char *conf_threshold_white = "/apps/asui/threshold_white";

//////////////////////////////////////////////////////////////////////////

GtkWidget *window_vbox, *main_box, *main_content_box, *section_box, *section_content_box;
/*
	window_vbox
		main_box (scrollable view)
			main_content_box (vbox)
				buttons...
	window_vbox
		section_box (vbox)
			header button
			scrollable view
				section_content_box (vbox)
					setting widgets...
*/

void new_scrolling_vbox( GtkWidget *parent, GtkWidget **container, GtkWidget **content ){
	// scrollable view
	*container = gtk_scrolled_window_new(NULL, NULL);
	gtk_container_set_border_width(GTK_CONTAINER(*container), 0);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(*container), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	hildon_helper_set_thumb_scrollbar(GTK_SCROLLED_WINDOW(*container), TRUE); // wide scrollbar
	gtk_box_pack_start(GTK_BOX(parent), *container, TRUE, TRUE, 0);
	gtk_widget_show(*container);
	// vbox in the scrollable view
	*content = gtk_vbox_new(FALSE, 5);
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(*container), *content);
	gtk_widget_show(*content);
}

void new_separator( ){
	GtkWidget *line = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(section_content_box), line, FALSE, FALSE, 10);
	gtk_widget_show(line);
}

void click_section_back_button( GtkWidget *widget, gpointer data ){
	// bound to the section header button to close section and return to main button list
	gtk_widget_destroy(section_box);
	gtk_widget_show(main_box);
}
void new_section_vbox( char *name ){
	// hide the main button box
	gtk_widget_hide(main_box);

	// create a vbox to hold main widgets
	section_box = gtk_vbox_new(FALSE, 10);
	gtk_container_add(GTK_CONTAINER(window_vbox), section_box);
	gtk_widget_show(section_box);
	// create section header button
	char buffer[200];
	snprintf(buffer, sizeof(buffer), "<<    %s", name);
	GtkWidget *button = gtk_button_new_with_label(buffer);
	gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(click_section_back_button), NULL);
	gtk_widget_set_size_request(button, -1, 60);
	gtk_box_pack_start(GTK_BOX(section_box), button, FALSE, FALSE, 0);
	gtk_widget_show(button);
	// create section scrolling_vbox for settings
	GtkWidget *scrollable;
	new_scrolling_vbox(section_box, &scrollable, &section_content_box);

	new_separator();
}

void new_message( char *message ){
	GtkWidget *label = gtk_label_new(message);
	gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);
	gtk_box_pack_start(GTK_BOX(section_content_box), label, FALSE, FALSE, 10);
	gtk_widget_show(label);
}

void default_checkbox_callback( GtkToggleButton *widget, gpointer data ){
	conf_set_bool((const char *)data, (gtk_toggle_button_get_active(widget) == TRUE ? 1 : 0));
}
GtkWidget *new_checkbox( const char *conf, char *label, void (*callback)(GtkToggleButton *widget, gpointer data) ){
	GtkWidget *checkbox = gtk_check_button_new_with_label(label);
	gtk_signal_connect(GTK_OBJECT(checkbox), "toggled", GTK_SIGNAL_FUNC(callback == NULL ? default_checkbox_callback : callback), (void *)conf);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbox), conf_get_bool(conf));
	gtk_box_pack_start(GTK_BOX(section_content_box), checkbox, FALSE, FALSE, 10);
	gtk_widget_show(checkbox);
	return checkbox;
}

void default_selector_callback( GtkComboBox *widget, gpointer data ){
	int index = gtk_combo_box_get_active(widget);
	conf_set_int((const char *)data, (index >= 0 ? index : 0));
}
GtkWidget *new_selector( const char *conf, char *name, const char **items, void (*callback)(GtkComboBox *widget, gpointer data) ){
	int i;

	// hbox
	GtkWidget *hbox = gtk_hbox_new(FALSE, 10);
	gtk_box_pack_start(GTK_BOX(section_content_box), hbox, FALSE, FALSE, 10);
	gtk_widget_show(hbox);
	// combo box
	GtkWidget *combo_box = gtk_combo_box_new_text();
	for(i = 0; items[i] != NULL; i++)
		gtk_combo_box_append_text(GTK_COMBO_BOX(combo_box), items[i]);
	gtk_combo_box_set_active(GTK_COMBO_BOX(combo_box), conf_get_int(conf));
	gtk_signal_connect(GTK_OBJECT(combo_box), "changed", GTK_SIGNAL_FUNC(callback == NULL ? default_selector_callback : callback), (void *)conf);
	gtk_box_pack_start(GTK_BOX(hbox), combo_box, FALSE, FALSE, 20);
	gtk_widget_show(combo_box);
	// label
	GtkWidget *label = gtk_label_new(name);
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
	gtk_widget_show(label);

	return combo_box;
}

//////////////////////////////////////////////////////////////////////////

#include "battery.h"
#include "clock.h"
#include "brightness.h"
#include "rbv_keys.h"
#include "button_modes.h"
#include "ui.h"
#include "system.h"

//////////////////////////////////////////////////////////////////////////

gint delete_event( GtkWidget *widget, GdkEvent *event, gpointer data ){
	return(FALSE);
}

void destroy_window( GtkWidget *widget, gpointer data ){
	gtk_main_quit();
}

void new_main_label( char *name ){
	GtkWidget *label = gtk_label_new(name);
	gtk_box_pack_start(GTK_BOX(main_content_box), label, FALSE, FALSE, 10);
	gtk_widget_show(label);
}

GtkWidget *new_main_button( GtkWidget *parent, char *name, void (*click_callback)(GtkWidget *widget, gpointer data) ){
	GtkWidget *button = gtk_button_new_with_label(name);
	gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(click_callback), NULL);
	gtk_widget_set_size_request(button, -1, 60);
	gtk_box_pack_start(GTK_BOX(parent), button, FALSE, FALSE, 0);
	gtk_widget_show(button);
	return button;
}

//////////////////////////////////////////////////////////////////////////

int main( int argc, char *argv[] ){
	// abort if settings app is already running
	{
		unsigned settings_open = 0;
		DIR *proc;
		if((proc = opendir("/proc")) != NULL){
			struct dirent *file;
			while((file = readdir(proc))){
				if(file->d_name[0] > '0' && file->d_name[0] <= '9'){
					char filepath[30];
					FILE *p;
					snprintf(filepath, sizeof(filepath), "/proc/%s/cmdline", file->d_name);
					if((p = fopen(filepath, "r")) != NULL){
						char cmdline[400];
						fgets(cmdline, sizeof(cmdline), p);
						fclose(p);
						if(!strcmp(cmdline, "/usr/bin/advanced-systemui-settings")) settings_open++;
						else if(!strcmp(cmdline, "/root/.asui-settings-test")) settings_open++;
					}
				}
			}
			closedir(proc);
		}
		if(settings_open > 1) return EXIT_SUCCESS;
	}

	// initialize dbus
	if((system_bus = dbus_bus_get_private(DBUS_BUS_SYSTEM, &dbus_error)) == NULL){
		fprintf(stderr, BINNAME ": can't connect to system method bus: %s", dbus_error.message);
		dbus_error_free(&dbus_error);
		return EXIT_FAILURE;
	}
	// initialize gtk
	gtk_init(&argc , &argv);
	// initialize gconf
	g_type_init();
	gconf_client = gconf_client_get_default();

	// get device model
	{
		FILE *fp;
		is_770 = is_800 = is_810 = 0;
		// code ported from advanced-backlight
		if((fp = fopen("/proc/component_version", "r")) != NULL){
			char version;
			fseek(fp, sizeof(char)*15, 0); // The important character is the 16th in the file
			fread(&version, sizeof(char), 1, fp);
			fclose(fp);
			switch(version){
			case '4': is_810 = 1; break;
			case '3': is_800 = 1; break;
			case '1': is_770 = 1; break;
			default:  is_810 = 1; // assume N810
			}
		} else
			is_810 = 1; // assume N810
	}

	// gtk window
	GtkWidget *window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect(GTK_OBJECT(window), "delete_event", GTK_SIGNAL_FUNC(delete_event), NULL);
	gtk_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(destroy_window), NULL);
	gtk_container_set_border_width(GTK_CONTAINER(window), 0);
	gtk_window_set_title(GTK_WINDOW(window), "ASUI Settings");
	gtk_widget_show(window);
	window_vbox = gtk_vbox_new(TRUE, 0);
	gtk_container_add(GTK_CONTAINER(window), window_vbox);
	gtk_widget_show(window_vbox);

	new_scrolling_vbox(window_vbox, &main_box, &main_content_box);
	new_main_label("Widgets");
	new_main_button(main_content_box, "Battery", battery_click_callback);
	new_main_button(main_content_box, "Clock", clock_click_callback);
	new_main_button(main_content_box, "Brightness", brightness_click_callback);
	new_main_label("Other");
	new_main_button(main_content_box, "RBV Keys", rbv_keys_click_callback);
	new_main_button(main_content_box, "Button Modes", button_modes_click_callback);
	new_main_button(main_content_box, "User Interface", ui_click_callback);
	new_main_button(main_content_box, "System", system_click_callback);
	// footer
	GtkWidget *line = gtk_hseparator_new(); gtk_box_pack_start(GTK_BOX(main_content_box), line, FALSE, FALSE, 10); gtk_widget_show(line);
	GtkWidget *label = gtk_label_new("all settings in this app instantly reload ASUI when changed");
	gtk_label_set_line_wrap(GTK_LABEL(label), TRUE); gtk_box_pack_start(GTK_BOX(main_content_box), label, FALSE, FALSE, 10); gtk_widget_show(label);

	// gtk main loop
	gtk_main();
	dbus_connection_close(system_bus);
	return EXIT_SUCCESS;
}
