//	Advanced System UI
//	Copyright (c) 2011 Brand Huntsman <http://qzx.com/mail/>

//////////////////////////////////////////////////////////////////////////

const char *bm_list5[] = {" not bound ", " LOCK ", " LOCK & BLANK ", " BLANK ", " SECURE ", NULL};
const char *bm_list4[] = {" nothing ",   " LOCK ", " LOCK & BLANK ", " BLANK ",             NULL};
const char *bm_list3[] = {               " LOCK ", " LOCK & BLANK ", " BLANK ",             NULL};

//////////////////////////////////////////////////////////////////////////

void button_modes_click_callback( GtkWidget *widget, gpointer data ){
	new_section_vbox("Button Modes"); // add setting widgets to section_content_box

	new_checkbox(conf_double_tap, "require double taps to start and stop services", NULL);

	new_separator();

	new_message("This works with the lock button (short and long), the secure button and the dpad center button");
	new_checkbox(conf_lock_and_close, "close ASUI after locking touchscreen", NULL);

	new_separator();

	new_message("Enabling this allows the POWER BUTTON + DPAD CENTER combo to always lock the screen");
	new_checkbox(conf_n800_lock_mode, "power button always opens ASUI and never closes it", NULL);

	new_separator();

	new_message("This does not effect rotating with hardware keys (BRV keys)");
	new_checkbox(conf_rotate_and_close, "close ASUI after rotating with on-screen buttons", NULL);

	new_separator();

	new_message("Enabling this allows you to manually lock the device with your pin code, make sure you know it!!!");
	new_checkbox(conf_secure_button, "enable secure button", NULL);
	new_message("None of the secure options below will work unless this is enabled");

	new_selector(conf_buttons_dpad_short, "DPAD CENTER short press", bm_list5, NULL);
	new_selector(conf_buttons_dpad_long, "DPAD CENTER long press", bm_list5, NULL);
	new_selector(conf_buttons_lock1_short, "lock button #1 short press", bm_list5, NULL);
	new_selector(conf_buttons_lock1_long, "lock button #1 long press", bm_list5, NULL);
	new_selector(conf_buttons_lock2_short, "lock button #2 short press", bm_list5, NULL);
	new_selector(conf_buttons_lock2_long, "lock button #2 long press", bm_list5, NULL);
	new_selector(conf_secure_action, "action to perform after pressing secure button", bm_list4, NULL);
	new_selector(conf_secure_power_action, "power button action when device is secured", bm_list3, NULL);

	new_message("If blank is used for power button action and screen does not autolock then there will be no way to lock the screen while secured (dpad center won't work)");

	new_separator();
}
