//	Advanced System UI
//	Copyright (c) 2011 Brand Huntsman <http://qzx.com/mail/>
//
//	all dsme code ported from powerlaunch
//	Copyright (c) 2007-2008 Austin Che

#include <stdio.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/un.h>

#include "main.h"
 #include "dsme.h"

#define DSME_GET_DEVICELOCK_CODE 0x1200
#define DSME_IN_GET_DEVICELOCK_CODE 0x1201
//#define DSME_SET_DEVICELOCK_CODE 0x1202
#define DSME_IN_SET_DEVICELOCK_CODE 0x1203

#define DSME_DISPLAY_BLANKING_PAUSE 0x0201
#define DSME_DISPLAY_BLANKING_ALLOW 0x0202
//#define DSME_SET_DISPLAY_BLANK_TIMEOUT 0x0203
//#define DSME_SET_DISPLAY_DIM_TIMEOUT 0x0204
//#define DSME_SET_DISPLAY_STATE 0x0280
//#define DSME_IN_DISPLAY_STATE 0x0285
#define DSME_SET_DISPLAY_BRIGHTNESS 0x0289

// soft power off doesn't appear to be any different than blanking the display

////////////////////////////////////////////////////////////////////////// GLOBALS

char *device_lock_code;

//////////////////////////////////////////////////////////////////////////

static int dsme_fd;

static void dsme_write( unsigned type ){
	#ifdef ARCH_armel
	struct {
		unsigned len;
		unsigned type;
	} message;
	message.len = sizeof(message);
	message.type = type;
	send(dsme_fd, (void *)&message, sizeof(message), 0);
	#endif
}

static void dsme_write_one_arg( unsigned type, unsigned arg ){
	#ifdef ARCH_armel
	struct {
		unsigned len;
		unsigned type;
		unsigned arg;
	} message;
	message.len = sizeof(message);
	message.type = type;
	message.arg = arg;
	send(dsme_fd, (void *)&message, sizeof(message), 0);
	#endif
}

//////////////////////////////////////////////////////////////////////////

int dsme_init( ){
	struct sockaddr_un addr;

	dsme_fd = socket(PF_UNIX, SOCK_STREAM, 0);
	if(dsme_fd < 0){
		error_write("can't open dsme socket");
		return 0;
	}

	memset(&addr, 0, sizeof(addr));
	addr.sun_family = AF_UNIX;
	strcpy(addr.sun_path, "/tmp/dsmesock");
	if(connect(dsme_fd, (struct sockaddr *)&addr, sizeof(addr)) < 0){
		close(dsme_fd);
		error_write("can't connect to dsme socket");
		return 0;
	}

/*
	g_io_channel_set_flags(server->dsme, G_IO_FLAG_NONBLOCK, NULL);
	g_io_channel_set_encoding(server->dsme, NULL, NULL);
	g_io_channel_set_buffered(server->dsme, FALSE);
*/

	device_lock_code = NULL;

	return dsme_fd;
}

void dsme_disconnect( ){
	#ifdef ARCH_armel
	dsme_allow_blanking(); // make sure blanking is enabled before exiting
	close(dsme_fd);
	#endif
}

//////////////////////////////////////////////////////////////////////////

#ifdef ARCH_armel

static int read_data( void *buffer, int len ){
	int rlen = read(dsme_fd, buffer, len);
	if(rlen != len){
		error_write("could not read %d bytes from dsme, got %d bytes", len, rlen);
		return -1;
	}
	return rlen;
}

static void parse_lock_code( void *buffer, int len ){
	struct {
		char str[16];	// "lock_code"
		unsigned a1;	// 0x01
		unsigned a2;	// 0x10
		unsigned a3;	// 0x01
		char code[12];	// the device code
	} *message = buffer;

	if(len != sizeof(*message)){
		error_write("unexpected data size: expected %d, got %d", sizeof(*message), len);
		return;
	}

	if(!strcmp(message->str, "lock_code"))
		set_string(&device_lock_code, message->code, 10); // max of 10 digits
	else
		error_write("unknown dsme lock code message with string %s", message->str);
}

#endif

void dsme_read( ){
	#ifdef ARCH_armel
	struct {
		unsigned len;
		unsigned type;
	} header;

	int rlen;
	if((rlen = read_data(&header, sizeof(header))) < 0){
		error_write("could not read dsme header");
		return;
	}

	char buffer[256];
	int data_size = header.len - rlen;
	if(data_size > (int)sizeof(buffer)){
		error_write("length(%d) in dsme header is too large", header.len);
		lseek(dsme_fd, 0, SEEK_END);
		return;
	}

	if((rlen = read_data(buffer, data_size)) < 0){
		error_write("could not read dsme data");
		return;
	}

	switch (header.type){
	case DSME_IN_GET_DEVICELOCK_CODE:
		parse_lock_code(buffer, rlen);
		break;
	default:
/*
		error_write("unhandled message from dsme of type 0x%x with %d bytes of data", header.type, rlen);
		int i;
		for(i = 0; i < rlen; i++){
			printf("%02x ", buffer[i]);
			if(i % 50 == 49) printf("\n");
		}
		if(rlen) printf("\n");
*/
		break;
	}
	#endif
}

////////////////////////////////////////////////////////////////////////// BRIGHTNESS

void dsme_pause_blanking( ){
	dsme_write(DSME_DISPLAY_BLANKING_PAUSE);
}

void dsme_allow_blanking( ){
	dsme_write(DSME_DISPLAY_BLANKING_ALLOW);
}

void dsme_set_brightness( unsigned level ){
	dsme_write_one_arg(DSME_SET_DISPLAY_BRIGHTNESS, (level * 2) + 1);
}

////////////////////////////////////////////////////////////////////////// DEVICE LOCK CODE

void dsme_query_devicelock_code( ){
	#ifdef ARCH_armel
	struct {
		unsigned len;
		unsigned type;
		char data[16];
		unsigned a1;
		unsigned a2; // this changes, not sure what this is
	} message;
	message.len = sizeof(message);
	message.type = DSME_GET_DEVICELOCK_CODE;
	strncpy(message.data, "lock_code", sizeof(message.data));
	message.a1 = 0x01;
	message.a2 = 0x00027ec8;

	// clear code
	set_string(&device_lock_code, NULL, 0);

	// this should cause dsme to send us back the lock code
	send(dsme_fd, (void *)&message, sizeof(message), 0);
	#endif
}
