#!/bin/sh

# copied from powerlaunch

source /etc/asui-svc

DAEMON=/usr/bin/advanced-systemui
#PIDFILE=/var/run/advanced-systemui.pid
INITFILE=/etc/init.d/advanced-systemui

PATH=/sbin:/bin:/usr/sbin:/usr/bin
DSMETOOL=/usr/sbin/dsmetool
DSMETOOL_PARAMETERS="-G root -U root -n -1 -f "
STOP_PARAMETERS="-k "

# abort if no executable exists
test -x $DAEMON || exit 0

set -e

source /etc/osso-af-init/af-defines.sh

asui_start()
{
	if ! pidof $DAEMON > /dev/null; then
		[ "$1" = "1" ] && printf "Starting Advanced SystemUI..."
		$DSMETOOL $DSMETOOL_PARAMETERS $DAEMON
		printf ".\n"
	fi
}
asui_stop()
{
	$DSMETOOL $STOP_PARAMETERS $DAEMON
	sleep 2
	if pidof $DAEMON > /dev/null; then
		$DSMETOOL -S 9 $STOP_PARAMETERS $DAEMON
		sleep 1
	fi
}

case "$1" in
start)
	if [ "$SYSTEMUI_STOP" == "true" ]; then
		if pidof systemui > /dev/null; then
			printf "* systemui is running - stopping it...\n"
			/etc/init.d/osso-systemui stop || exit $?
		fi
	fi

	asui_start 1
	;;

stop)
	echo -n "Stopping Advanced SystemUI..."
	asui_stop
	printf ".\n"

	if [ "$SYSTEMUI_START" == "true" ]; then
		if ! pidof systemui > /dev/null; then
			/etc/init.d/osso-systemui start || exit $?
		fi
	fi
	;;

restart|force-reload)
	printf "Restarting Advanced SystemUI..."
	asui_stop
	asui_start 0
	;;

*)
	printf "Usage: $INITFILE {start|stop|restart|force-reload}\n" >&2
	exit 1
	;;
esac

exit 0
