#include <dbus/dbus.h>

#define _STRING_ DBUS_TYPE_STRING
#define _BOOL_ DBUS_TYPE_BOOLEAN
#define _UINT32_ DBUS_TYPE_UINT32
#define _INT32_ DBUS_TYPE_INT32
#define _ARRAY_ DBUS_TYPE_ARRAY
//#define _VARIANT_ DBUS_TYPE_VARIANT
#define _END_ DBUS_TYPE_INVALID

extern DBusError dbus_error;
extern unsigned dbus_listening;

extern unsigned original_screen_autolock, original_screen_stayslit;

//////////////////////////////////////////////////////////////////////////

extern char dbus_wakeup_message;
extern int dbus_wakeup_fd;

#define _WAKEUP_SHOW_ (char)1
#define _WAKEUP_HIDE_ (char)2
#define _WAKEUP_ROTATE_LEFT_ (char)3
#define _WAKEUP_ROTATE_RIGHT_ (char)4
#define _WAKEUP_POWER_BUTTON_ (char)5
#define _WAKEUP_LOCK_BUTTON_ (char)6
#define _WAKEUP_DEVICE_LOCK_ (char)7
#define _WAKEUP_REFRESH_ (char)8
#define _WAKEUP_SHUTDOWN_ (char)9

#define dbus_send_wakeup(message) { dbus_wakeup_message = message; write(dbus_wakeup_fd, (void *)&dbus_wakeup_message, 1); }

//////////////////////////////////////////////////////////////////////////

int dbus_init( );
void dbus_disconnect( );

void dbus_send_method( const char *destination, const char *path, const char *interface, const char *method, int first_arg_type, ... );
void dbus_send_signal( const char *path, const char *interface, const char *signal, int first_arg_type, ... );

void dbus_recv_method( DBusPendingCallNotifyFunction callback, const char *destination, const char *path, const char *interface, const char *method, int first_arg_type, ... );
void dbus_flush_messages( );

void dbus_send_session_method( const char *destination, const char *path, const char *interface, const char *method, int first_arg_type, ... );

void notify_screen_locked( );
void notify_screen_unlocked( );

void dbus_send_charging_status_signal( );
void dbus_send_battery_capacity_signal( );
