//	Advanced System UI
//	Copyright (c) 2010-2011 Brand Huntsman <http://qzx.com/mail/>

#include "window.h"
#include "main.h"
#include "draw.h"
#include "config.h"
#include "hardware.h"

//////////////////////////////////////////////////////////////////////////

void draw_rotate1_button( unsigned force, int x, int y ){
	if(!window.supports_rotation) return;

	if(force){
		// background for all buttons is cleared by draw_window()
	} else if(hw_changes & HW_ROTATION){
		// button background
		x_set_color(bg_color);
		x_fill_rectangle(x, y, 80, 80);
	} else return;

	if(window.width > window.height){
		if(window.orientation == O_LANDSCAPE)
			draw_image(&im_portrait, x+8, y+8);
		else
			draw_image(&im_landscape_inv, x+8, y+8);
	} else {
		if(window.orientation == O_PORTRAIT)
			draw_image(&im_portrait_inv, x+8, y+8);
		else
			draw_image(&im_portrait, x+8, y+8);
	}

	draw_tap_markers(x, y, 80, 1, 1); // short and long taps
}

void draw_rotate2_button( unsigned force, int x, int y ){
	if(!window.supports_rotation) return;

	if(force){
	// background for all buttons is cleared by draw_window()
	} else if(hw_changes & HW_ROTATION){
		// button background
		x_set_color(bg_color);
		x_fill_rectangle(x, y, 80, 80);
	} else return;

	if(window.width > window.height){
		if(window.orientation == O_LANDSCAPE)
			draw_image(&im_landscape_inv, x+8, y+8);
		else
			draw_image(&im_portrait_inv, x+8, y+8);
	} else {
		if(window.orientation == O_PORTRAIT)
			draw_image(&im_portrait, x+8, y+8);
		else
			draw_image(&im_landscape_inv, x+8, y+8);
	}

	draw_tap_markers(x, y, 80, 1, 1); // short and long taps
}

void draw_rotate3_button( unsigned force, int x, int y ){
	if(!window.supports_rotation) return;

	if(force){
		// background for all buttons is cleared by draw_window()
	} else if(hw_changes & HW_ROTATION){
		// button background
		x_set_color(bg_color);
		x_fill_rectangle(x, y, 80, 80);
	} else return;

	if(window.width > window.height){
		if(window.orientation == O_LANDSCAPE)
			draw_image(&im_portrait_inv, x+8, y+8);
		else
			draw_image(&im_portrait, x+8, y+8);
	} else {
		if(window.orientation == O_PORTRAIT)
			draw_image(&im_landscape_inv, x+8, y+8);
		else
			draw_image(&im_portrait_inv, x+8, y+8);
	}

	draw_tap_markers(x, y, 80, 1, 1); // short and long taps
}

//////////////////////////////////////////////////////////////////////////

void click_rotate1_button( ){
	if(!window.supports_rotation) return;

	if(click.type == CLICK_HOLD){

		// highlight to indicate long press
		highlight_long_press(widget_x, widget_y, 80,80);

	} else if(click.type == CLICK_SHORT || click.type == CLICK_LONG){

		if(throttle_taps(&ui_throttle)) return;

		highlight_selected_area(widget_x, widget_y, 80,80);
		unsigned keep_mapped = (click.type == CLICK_SHORT ? !cfg_rotate_and_close : cfg_rotate_and_close);
		if(window.orientation != O_LANDSCAPE)
			rotate_screen(O_LANDSCAPE, keep_mapped);
		else
			rotate_screen(O_PORTRAIT, keep_mapped);

		finalize_tap(ui_throttle);

	}
}

void click_rotate2_button( ){
	if(!window.supports_rotation) return;

	if(click.type == CLICK_HOLD){

		// highlight to indicate long press
		highlight_long_press(widget_x, widget_y, 80,80);

	} else if(click.type == CLICK_SHORT || click.type == CLICK_LONG){

		if(throttle_taps(&ui_throttle)) return;

		highlight_selected_area(widget_x, widget_y, 80,80);
		unsigned keep_mapped = (click.type == CLICK_SHORT ? !cfg_rotate_and_close : cfg_rotate_and_close);
		if(window.orientation != O_LANDSCAPE && window.orientation != O_PORTRAIT)
			rotate_screen(O_PORTRAIT, keep_mapped);
		else
			rotate_screen(O_LANDSCAPE_INV, keep_mapped);
		//  l   pLP
		//  p   lLP
		//  L   lpP
		//  P   lpL

		finalize_tap(ui_throttle);

	}
}

void click_rotate3_button( ){
	if(!window.supports_rotation) return;

	if(click.type == CLICK_HOLD){

		// highlight to indicate long press
		highlight_long_press(widget_x, widget_y, 80,80);

	} else if(click.type == CLICK_SHORT || click.type == CLICK_LONG){

		if(throttle_taps(&ui_throttle)) return;

		highlight_selected_area(widget_x, widget_y, 80,80);
		unsigned keep_mapped = (click.type == CLICK_SHORT ? !cfg_rotate_and_close : cfg_rotate_and_close);
		if(window.orientation != O_PORTRAIT_INV)
			rotate_screen(O_PORTRAIT_INV, keep_mapped);
		else
			rotate_screen(O_LANDSCAPE_INV, keep_mapped);

		finalize_tap(ui_throttle);

	}
}

////////////////////////////////////////////////////////////////////////// BUTTON

s_button button_rotate1 = {"rotate1", "/apps/asui_state/bcell_rotate1", draw_rotate1_button, click_rotate1_button, 0};
s_button button_rotate2 = {"rotate2", "/apps/asui_state/bcell_rotate2", draw_rotate2_button, click_rotate2_button, 0};
s_button button_rotate3 = {"rotate3", "/apps/asui_state/bcell_rotate3", draw_rotate3_button, click_rotate3_button, 0};
