//	Advanced System UI
//	Copyright (c) 2011 Brand Huntsman <http://qzx.com/mail/>

#include "window.h"
#include "main.h"
#include "draw.h"
#include "text.h"
#include "config.h"
#include "hardware.h"

//////////////////////////////////////////////////////////////////////////

// ASUI or some other program randomly disables key autorepeat
// this hack can be used to turn it back on

void draw_key_repeat_button( unsigned force, int x, int y ){
	if(force){
		// background for all buttons is cleared by draw_window()
		keyrepeat_button_page = primary_widgets;
	} else if(hw_changes & HW_KEY_REPEAT){
		// button background
		x_set_color(bg_color);
		x_fill_rectangle(x, y, 80, 80);
	} else return;

	unsigned cx = x+40, cy = y+40;

	draw_text("key", 16, fg2_color, cx, cy-14, ALIGN_CENTER, ALIGN_BASELINE, 0);
	draw_text("repeat", 16, fg2_color, cx, cy+6, ALIGN_CENTER, ALIGN_BASELINE, 0);
	if(hw_key_repeat)
		draw_text("ON", 16, fg2_color, cx, cy+26, ALIGN_CENTER, ALIGN_BASELINE, 0);
	else
		draw_text("OFF", 16, red_status_color, cx, cy+26, ALIGN_CENTER, ALIGN_BASELINE, 0);

	draw_tap_markers(x, y, 80, 1, 0); // short tap only
}

//////////////////////////////////////////////////////////////////////////

void click_key_repeat_button( ){
	if(click.type != CLICK_SHORT) return;

	highlight_selected_area(widget_x, widget_y, 80,80);
	if(hw_key_repeat)
		XAutoRepeatOff(window.display);
	else
		XAutoRepeatOn(window.display);
	hw_key_repeat = (hw_key_repeat ? 0 : 1);

	// redraw button
	x_set_color(bg_color);
	x_fill_rectangle(widget_x, widget_y, 80, 80);
	draw_key_repeat_button(1, widget_x, widget_y);
	x_flush();
}

////////////////////////////////////////////////////////////////////////// BUTTON

s_button button_key_repeat = {"*repeat", "/apps/asui_state/bcell_key_repeat", draw_key_repeat_button, click_key_repeat_button, 0};
