# -*- coding: utf-8 -*-
'''
Advanced Power
2008-2009(c) Kirill Plyashkevich <ru.spirit@gmail.com>
Maemo 4 statusbar item
'''

import gtk
from abstract import AbstractAdvancedPower
from hildondesktop import StatusbarItem
from advpowlib.util.locale import Locale

class AdvancedPowerMaemo4(AbstractAdvancedPower, StatusbarItem):

  def __init__(self):
    AbstractAdvancedPower.__init__(self)

  def __super_init__(self):
    StatusbarItem.__init__(self)

  def create_statusbar_button(self):
    self.button = gtk.ToggleButton()
    self.button.set_name('ap_sb_button')
    self.button.set_size_request(40,40)
    self.button.set_alignment(0.5, 0.5)
    self.button.connect('clicked', self.popup_menu)
    self.add(self.button)

  def update_button_image(self, image):
    self.button.set_image(image)

  def update_menu_mode(self, key):
    menu = getattr(self, '%s_menu' % key)
    if self.monitor and menu:
      ctext = Locale.get_item('%s_%s' % (key, self.monitor.get_value(key)))
      menu_children = menu.get_children()
      for x in menu_children:
        if x.child:
          x.set_sensitive(x.child.get_text() != ctext)

  def add_plain_menu_item(self, text, parent = None, selectable = False, greyed = True):
    menu_item = gtk.MenuItem(text)
    if not parent:
      parent = self.menu
    parent.append(menu_item)
    menu_item.set_sensitive(selectable)
    if not selectable and not greyed and menu_item.child:
      menu_item.child.modify_fg(gtk.STATE_INSENSITIVE,  menu_item.child.rc_get_style().copy().fg[gtk.STATE_NORMAL])
    return menu_item

  def create_menu(self):
    self.menu = gtk.Menu()
    if self.monitor:
      s_settings = self.cfg.sort_plugins_by_pos()
      s_settings = [item for item in s_settings if (item[0] in self.menu_cb_map and self.cfg.get_plugins_value(item[0]))]
      s_list = self.monitor.get_property_list()
      s_list = [str(item) for item in s_list]
      for x in s_settings:
        if self.menu_cb_map[x[0]] == 'none':
          getattr(self, 'add_%s' % (x[0]))(x[0])
        elif not x[0] in s_list:
          continue
        else:
          self._add_upd_item(x[0], self.menu_cb_map[x[0]])
    else:
      menu_start_apmd = self.add_plain_menu_item(Locale.get('apmd_start'), selectable=True)
      menu_start_apmd.connect('activate', self.start_apm_daemon)
    self.add_plain_menu_item('%s...' % Locale.get_item('settings'), selectable=True).connect('activate', self.show_settings_dialog)
    self.menu.set_name('pybattery_menu')
    self.menu.connect('selection-done', self.menu_done)
    self.menu.show_all()

  def destroy_menu(self):
    if self.menu:
      self.menu.destroy()

  def popup_menu(self, widget, data=None):
    if self.button.get_active():
      if self.recreate_menu_flag:
        self.recreate_menu()
        self.recreate_menu_flag = False
      self.menu.popup(None,None,self.menu_position,0,gtk.get_current_event_time())

  def menu_done(self, widget, data=None):
    self.button.set_active(False)
    widget.popdown()

  def menu_position(self,data=None):
    (reqw, reqh) = self.menu.size_request()
    (x,y) = self.button.get_parent_window().get_position()
    button_allocation = self.button.get_allocation()
    y = y + button_allocation.y + button_allocation.height + 10
    x = x + button_allocation.x + button_allocation.width - reqw
    return (x,y,True)

  def add_custom_group(self, key, items):
    menu_item = self.add_plain_menu_item(text=Locale.get_item('%s_menu' % (key)), selectable=True)
    submenu = gtk.Menu()
    for item in items:
      if item['type'] == 'upd_item':
        actions = {}
        try:
          actions = item['actions']
        except KeyError:
          pass
        self._add_upd_item(item['key'], 'auto', parent=submenu, connect=actions)
      elif item['type'] == 'plain':
        self.add_plain_menu_item(text=Locale.get_item(item['key']), selectable=True, parent=submenu).connect('activate', item['action'])
    menu_item.set_submenu(submenu)

  def add_mode_group(self, key, modes):
    c_mode = str(self.monitor.get_value(key))
    mode_item = self.add_plain_menu_item(text=Locale.get_item('%s_menu' % (key)), selectable=True)
    mode_item_menu = gtk.Menu()
    group = None
    for x in modes:
      group = self.add_plain_menu_item(text=Locale.get_item('%s_%s' % (key, x)), selectable=True, parent=mode_item_menu)
      group.connect('activate', getattr(self, 'set_%s' % (key)), x)
      group.set_sensitive( x != c_mode)
    mode_item.set_submenu(mode_item_menu)
    setattr(self, '%s_menu' % key, mode_item_menu)
    return getattr(self, '%s_menu' % (key))

  def set_menu_item_text(self, item, text):
    if item and item.child:
      ivisible = self.button.get_active()
      if ivisible:
        item.hide()
      item.child.set_text(text)
      if ivisible:
        item.show()

def hd_plugin_get_objects():
  plugin = AdvancedPowerMaemo4()
  return [plugin] 
