/*
 * Copyright (C) 2008 Adam Harwell, all rights reserved.
 *
 * Contact: Adam Harwell <adam.harwell@trinity.edu>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef ADVANCED_BACKLIGHT_PLUGIN_H
#define ADVANCED_BACKLIGHT_PLUGIN_H

#include <glib-object.h>

/* For Status Bar plugins */
#include <libhildondesktop/statusbar-item.h>

G_BEGIN_DECLS

/* Common struct types declarations */
typedef struct _AdvancedBacklightPlugin AdvancedBacklightPlugin;
typedef struct _AdvancedBacklightPluginClass AdvancedBacklightPluginClass;
typedef struct _AdvancedBacklightPluginPrivate AdvancedBacklightPluginPrivate;

/* Common macros */
#define TYPE_ADVANCED_BACKLIGHT_PLUGIN            (advanced_backlight_plugin_get_type ())
#define ADVANCED_BACKLIGHT_PLUGIN(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADVANCED_BACKLIGHT_PLUGIN, AdvancedBacklightPlugin))
#define ADVANCED_BACKLIGHT_PLUGIN_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  TYPE_ADVANCED_BACKLIGHT_PLUGIN, AdvancedBacklightPluginClass))
#define IS_ADVANCED_BACKLIGHT_PLUGIN(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADVANCED_BACKLIGHT_PLUGIN))
#define IS_ADVANCED_BACKLIGHT_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  TYPE_ADVANCED_BACKLIGHT_PLUGIN))
#define ADVANCED_BACKLIGHT_PLUGIN_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  TYPE_ADVANCED_BACKLIGHT_PLUGIN, AdvancedBacklightPluginClass))

/* Instance struct */
struct _AdvancedBacklightPlugin
{
	  StatusbarItem sbitem;

	    AdvancedBacklightPluginPrivate *priv;
};

/* Class struct */
struct _AdvancedBacklightPluginClass
{
	  StatusbarItemClass parent_class;
};

GType  advanced_backlight_plugin_get_type  (void);

G_END_DECLS

#endif /* ADVANCED_BACKLIGHT_PLUGIN_H */
