/*
 * haze-plugin: An account plugin for telepathy-haze
 * Copyright (C) 2007 Collabora Ltd.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef _HAZE_PLUGIN_H_
#define _HAZE_PLUGIN_H_

#include "libosso-rtcom-accounts/rtcom-account-plugin.h"
#include "libosso-rtcom-accounts/rtcom-account-item.h"
#include <libmissioncontrol/mc-profile.h>


G_BEGIN_DECLS

#define HAZE_TYPE_PLUGIN             (haze_plugin_get_type ())
#define HAZE_PLUGIN(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), HAZE_TYPE_PLUGIN, HazePlugin))
#define HAZE_PLUGIN_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), HAZE_TYPE_PLUGIN, HazePluginClass))
#define HAZE_IS_PLUGIN(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), HAZE_TYPE_PLUGIN))
#define HAZE_IS_PLUGIN_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), HAZE_TYPE_PLUGIN))
#define HAZE_PLUGIN_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), HAZE_TYPE_PLUGIN, HazePluginClass))

typedef struct _HazePluginClass HazePluginClass;
typedef struct _HazePlugin HazePlugin;

struct _HazePluginClass
{
    RtcomAccountPluginClass parent_class;
};

struct _HazePlugin
{
    RtcomAccountPlugin parent_instance;
};

GType haze_plugin_get_type (void) G_GNUC_CONST;


G_END_DECLS

#endif /* _HAZE_PLUGIN_H_ */
