import gtk

class Preferences(gtk.Dialog):
    def __init__(self, parent, config):
        gtk.Dialog.__init__(self, _("Preferences"), parent)
        self.config = config
        self.set_default_size(500, -1)
        
        rg_label = gtk.Label()
        rg_label.set_markup("<b>%s</b>" % _("Replaygain Preamp (db)"))
        rg_label.set_alignment(0, 0)
        self.vbox.pack_start(rg_label, expand=False, padding=5)
        
        rg_scale = gtk.HScale()
        rg_scale.set_range(-10.0, 10.0)
        rg_scale.set_value(self.config["rg-preamp"])
        rg_scale.connect("value-changed", self._on_rg_changed)
        rg_scale.set_update_policy(gtk.UPDATE_DELAYED)
        self.vbox.pack_start(rg_scale)
        
        no_rg_label = gtk.Label()
        no_rg_label.set_markup("<b>%s</b>" % _("No Replaygain Amp (db)"))
        no_rg_label.set_alignment(0, 0)
        self.vbox.pack_start(no_rg_label, expand=False, padding=5)

        no_rg_scale = gtk.HScale()
        no_rg_scale.set_range(-10.0, 10.0)
        no_rg_scale.set_value(self.config["no-rg-preamp"])
        no_rg_scale.connect("value-changed", self._on_no_rg_changed)
        no_rg_scale.set_update_policy(gtk.UPDATE_DELAYED)
        self.vbox.pack_start(no_rg_scale)

        close = gtk.Button(stock=gtk.STOCK_CLOSE)
        close.connect("clicked", self._on_close)
        self.action_area.pack_start(close)
        
        self.connect("delete-event", self._on_close)
    
    def _on_rg_changed(self, caller):
        self.config["rg-preamp"] = caller.get_value()
    
    def _on_no_rg_changed(self, caller):
        self.config["no-rg-preamp"] = caller.get_value()
    
    def _on_close(self, caller, event=None):
        self.hide()
        return True
