import commands
import os.path
import gtk
import random

VERSION = "0.3.0"
IS_MAEMO = commands.getoutput("uname -m")[0:3] == "arm" # if cpu type is ARM, we are on maemo

db_file = os.path.expanduser("~/.musicdb")
music_dirs = ("~/music/", "/media/mmc2", "/media/mmc1")
blacklist_dirs = ("/media/mmc2/map",)
known_exts = ("mp3", "ogg")

if IS_MAEMO:
    MAX_VOL = 10.0
    img_path = "/usr/share/youamp/%s"
else: 
    MAX_VOL = 4.0
    img_path = "data/%s"

class Playlist(gtk.ListStore):
    def __init__(self, playlist=None):
        gtk.ListStore.__init__(self, object)
        
        # shuffled positions
        self._shuffled_pos = None
        
        if playlist is not None:
            self.update(playlist)        
        
    def update(self, playlist):
        self.clear()

        for song in playlist:
            self.append((song,))
    
    def shuffle(self, shuffle):
        """shuffle/ unshuffle the playlist"""
        if shuffle:
            self._shuffled_pos = range(0, len(self))
            # build mapping
            random.shuffle(self._shuffled_pos)
            self.reorder(self._shuffled_pos)
        else:
            # build reverse mapping
            rev_map = range(0, len(self))
            for i in xrange(0, len(self)):
                rev_map[self._shuffled_pos[i]] = i
                
            self.reorder(rev_map)
            self._shuffled_pos = None    
    
    def __getitem__(self, k):
        return gtk.ListStore.__getitem__(self, k)[0]
    
    def __setitem__(self, k, v):
        gtk.ListStore.__getitem__(self, k)[0] = v
    
class Song(dict):
    def __init__(self, data):
        dict.__init__(self)
        
        self.data = None
        
        if(isinstance(data, tuple)):
            self.data = data
            self.uri = self.data[0]
            self["title"] = self.data[1]
            self["artist"] = self.data[2]
            self["album"] = self.data[3]
        else:
            self.uri = data
    
    def get_tuple(self):
        if not self.data is None:
            return self.data
        else:
            return (self.uri, self["title"], self["artist"] , self["album"])

