using GLib;

namespace XMaeme {
	public class Xmame : GLib.Object {
		public const string EXECUTABLE = "xmame";
		public const string NO_SOUND = "-nosnd";
		public const string FULLSCREEN = "-fullscreen";
		public const string ROR = "-ror";
		public const string SCALE = "-scale";

		public static string getRompathFromXmamerc(string path) {
			string contents;
			string[] lines = null;

			try {
				if(!FileUtils.get_contents(path, out contents)){ return null; }
				lines = contents.split("\n");
				if(null == lines){ return null; }

				foreach(string line in lines) {
					if(line.has_prefix("rompath")) {
						return line.split_set(" 	", 2)[1];
					}
				}
			} catch(FileError fe) {
			}

			return null;
		}// getRompathFromXmamerc

		public static int launch(string romname, bool useSound, bool fullScreen, bool rotate, bool doubleSize) {
			string fullrom;
			string[] argv = new string[8];
			uint i = 0;

			fullrom = XMaeme.getRomFullPath(romname, RomType.MAME);

			argv[i++] = EXECUTABLE;
			argv[i++] = (null == fullrom? romname: fullrom);
			if(!useSound){ argv[i++] = NO_SOUND; }
			argv[i++] = FULLSCREEN;
			if(rotate){ argv[i++] = ROR; }
			if(doubleSize) {
				argv[i++] = SCALE;
				argv[i++] = "2";
			}
			argv[i++] = null;

			return XMaeme.launch_any(argv);
		}// launch
	}// Xmame
}// XMaeme
