using GLib;
using Gtk;
using Glade;

namespace XMaeme {
	public static void initialize_specific() {
		weak XML xml = XMaeme.GladeXml;
		weak Window mainwindow = (Window)xml.get_widget("mainwindow");

		mainwindow.show_all();
	}// initialize_specific

	public static void show_information(string message) {
		MessageDialog d = new MessageDialog(null, (DialogFlags)0, MessageType.ERROR, ButtonsType.OK, "Error: " + message);
		d.run();
	}// show_information

	public static int get_spin_value(string spin_name) {
		return ((SpinButton)XMaeme.GladeXml.get_widget("nes_frameskip")).get_value_as_int();
	}// get_spin_value

	public static void set_spin_value(string spin_name, int newval) {
		((SpinButton)XMaeme.GladeXml.get_widget("nes_frameskip")).set_value(newval);
	}// get_spin_value

	public static void launch_file_browser(weak ComboBox romlist, string default_path) {
		weak Window parent = (Window)XMaeme.GladeXml.get_widget("mainwindow");
		FileChooserDialog filedialog = new FileChooserDialog("Choose ROM", parent, FileChooserAction.OPEN, STOCK_CANCEL, ResponseType.CANCEL, STOCK_OPEN, ResponseType.OK, null);

		if(null != default_path){ filedialog.set_current_folder(default_path); }

		if(ResponseType.OK == filedialog.run()) {
			romlist.prepend_text(filedialog.get_filename());
			romlist.set_active(0);
		}// file chosen

		filedialog.destroy();
	}// launch_file_browser
}// XMaeme
