using GLib;
using Gtk;
using Glade;


namespace XMaeme {
	enum RomType {	MAME,
			NES,
			GBA,
			NEOGEO,
			GBC,
			LYNX }

	public class XMaeme : Gtk.Object {
		public const string[] ListNames = {	"mame_romlist",
							"nes_romlist",
							"gba_romlist",
							"ng_romlist",
							"gbc_romlist",
							"lynx_romlist",
							null };

		public const string[] Emulators = {	"xmame",
							"fceu",
							"vba",
							"gngeo",
							"sdlgnuboy",
							"handy_sdl",
							null };

		public const string[] Tabs = {	"mame_panel",
						"nes_panel",
						"gba_panel",
						"ng_panel",
						"gbc_panel",
						"lynx_panel",
						null };

		public const string[] Subpaths = {	"mame",
							"nes",
							"gba",
							"neogeo",
							"gbc",
							"lynx",
							null };

		public const string[] SearchPaths = {	"/media/mmc1/roms/",

							"/media/mmc2/roms/",
							null };
		public const string[] RCPaths = {	"/etc/xmame/xmamerc",
							"/home/user/.xmame/xmamerc",
							null };
		public const string[] Extensions = {	".zip",
							".gz",
							".nes",
							".gb",
							".gbc",
							".rom",
							".lnx",
							null };

		//Why the hell am I doing this?
		public const int ROMTYPES_NUM = 6;
		public const int[] RomTypes = {	RomType.MAME,
						RomType.NES,
						RomType.GBA,
						RomType.NEOGEO,
						RomType.GBC,
						RomType.LYNX,
						null };

		public static XML GladeXml;

		public static int main(string[] args) {
			Gtk.set_locale();
			Gtk.init(ref args);

			GladeXml = new XML.from_buffer(GladeBuffer.glade_buf, (int)(GladeBuffer.glade_buf.len()+1), null, null);
			GladeXml.signal_autoconnect();

			initialize();

			Gtk.main();

			return 0;
		}// main

		public static void initialize() {
			weak Widget helptab = null;
			weak Notebook notebook = null;
			GLib.List<string>	filelist = null;
			weak ComboBox romlist = null;
			int	visible_tabs = 0;
			string  found = null;

			// Hildon-specific initialization
			initialize_specific();

			helptab  = GladeXml.get_widget("help_about");
 			notebook = (Notebook)GladeXml.get_widget("notebook1");

			for(int romtype = 0; romtype<ROMTYPES_NUM; ++romtype) {
			//foreach(int romtype in RomTypes) {
				found = Environment.find_program_in_path(Emulators[romtype]);

				if(null != found) {
					++visible_tabs;
				}// this emulator is installed
				else {
					Widget tab = GladeXml.get_widget(Tabs[romtype]);
					tab.hide_all();
					continue;
				}// hide tab if not installed


				filelist = getInstalledRoms(romtype);
				//stdout.printf("End\n");
				//stdout.printf("Got filelist %x\n", filelist);
				romlist = (ComboBox)GladeXml.get_widget(ListNames[romtype]);
				foreach(string file in filelist) {
					romlist.append_text(file);
				}// populate combobox
				romlist.set_active(0);
				filelist = null;
			}// initialize each type

			if(0 == visible_tabs) {
				notebook.set_show_tabs(false);
				helptab.show_all();
			}// no emulators installed in PATH
			else{ helptab.hide_all(); }
		}// init

		public static GLib.List<string> getInstalledRoms(int romtype) {
			string	subpath = Subpaths[romtype],
				currpath = "";
			weak GLib.List<string>	rv;
			bool mameRom = false;

			// stdout.printf("Romtype %d\n", romtype);

			if(RomType.MAME == romtype) {
				// stdout.printf("MAME\n");
				foreach(string path in RCPaths) {
					//stdout.printf("%s\n", path);
					currpath = Xmame.getRompathFromXmamerc(path);
					if(null != currpath) {
						rv.concat(getInstalledRomsInPath(currpath, romtype));
					}
				}

				mameRom = true;
			}// MAME

			// stdout.printf("1\n");
			// foreach(string s in rv){ stdout.printf("%s ", s); }
			// stdout.printf("\n");

			foreach(string path in SearchPaths) {
				//stdout.printf("Searching path %s\n", path);
				currpath = Path.build_filename(path, subpath);
				//stdout.printf("Getting roms for %s\n", currpath);
				rv.concat(getInstalledRomsInPath(currpath, romtype));

				if(mameRom) {
					rv.concat(getInstalledRomsInPath(path, romtype));
				}// check base roms/ dir for MAME as well
			}// search each base path

			// stdout.printf("2\n");
			// foreach(string s in rv){ stdout.printf("%s ", s); }
			// stdout.printf("\n");


			currpath = Path.build_filename(Environment.get_home_dir(), "MyDocs", ".documents", ".games");
			if(mameRom) {
				rv.concat(getInstalledRomsInPath(currpath, romtype));
			}// check base dir for MAME as well
			currpath = Path.build_filename(currpath, Subpaths[romtype]);
			rv.concat(getInstalledRomsInPath(currpath, romtype));

			// stdout.printf("3\n");
			// foreach(string s in rv){ stdout.printf("%s ", s); }
			// stdout.printf("\n");


			currpath = Path.build_filename(Environment.get_home_dir(), "MyDocs", ".games");
			if(mameRom) {
				rv.concat(getInstalledRomsInPath(currpath, romtype));
			}// check base dir for MAME as well
			currpath = Path.build_filename(currpath, Subpaths[romtype]);
			rv.concat(getInstalledRomsInPath(currpath, romtype));

			// stdout.printf("4 %s\n", currpath);
			// foreach(string s in rv){ stdout.printf("%s ", s); }
			// stdout.printf("\n");


			// foreach(string file in rv) {
			// 	stdout.printf("%s\n", file);
			// }

			return (0 == rv.length())? null: rv.copy();
		}// getInstalledRoms

		public static GLib.List<string> getInstalledRomsInPath(string path, int romtype) {
			weak GLib.List<string> romlist;
			Dir dir = null;
			string filename = null;
			
			try {
				dir = Dir.open(path);
				if(null == dir){ return null; }

				for(filename = dir.read_name(); (null != filename); filename = dir.read_name()) {
					//stdout.printf("Appending %s\n", filename);
					foreach(string subpath in Subpaths) {
						if(filename == subpath){ filename = null; }
					}
					if(null != filename){ romlist.append(filename); }
				}// read in file list
			} catch(FileError fe) {
				return null;
			}

			return (0 == romlist.length())? null: romlist.copy();
		}// getInstalledRomsInPath

		public static string getRomFullPath(string romname, int romtype) {
			if(Path.is_absolute(romname)){ return null; }

			string fullrom = null;

			foreach(string path in SearchPaths) {
				string currpath = Path.build_filename(path, Subpaths[romtype]);
				fullrom = isRomInPath(romname, currpath);
				if(null == fullrom) {
					fullrom = isRomInPath(romname, path);
				}

				if(null != fullrom){ return fullrom; }
			}

			fullrom = isRomInPath(romname, Path.build_filename(Environment.get_home_dir(), "MyDocs", ".documents", ".games", Subpaths[romtype]));
			if(null == fullrom) {
				fullrom = isRomInPath(romname, Path.build_filename(Environment.get_home_dir(), "MyDocs", ".documents", ".games"));
			}
			fullrom = isRomInPath(romname, Path.build_filename(Environment.get_home_dir(), "MyDocs", ".games", Subpaths[romtype]));
			if(null == fullrom) {
				fullrom = isRomInPath(romname, Path.build_filename(Environment.get_home_dir(), "MyDocs", ".games"));
			}

			return fullrom;
		}// getRomFullPath

		public static string isRomInPath(string romname, string path) {
			Dir dir = null;
			string filename = null;

			try {
				// stdout.printf("Searching %s for %s\n", path, romname);
				dir = Dir.open(path);
				if(null == dir){ return null; }

				for(filename = dir.read_name(); null != filename; filename = dir.read_name()) {
					if(romname == filename){ return Path.build_filename(path, filename); }
					foreach(string ext in Extensions) {
						if(romname == (filename + ext)) {
							// stdout.printf("Found %s%s%s\n", path, filename, ext);
							return Path.build_filename(path, filename, ext);
						}
					}
					
				}
			} catch(FileError fe) { }

			return null;
		}// isRomInPath

		public static void browse(int romtype) {
			string defaultpath = Path.build_filename(SearchPaths[0], Subpaths[romtype]);
			launch_file_browser((ComboBox)GladeXml.get_widget(ListNames[romtype]), (FileUtils.test(defaultpath, FileTest.EXISTS)? defaultpath: null));
		}// browse

		public static int launch_any(string[] args) {
			foreach(string arg in args) {
				stdout.printf("%s ", arg);
			}
			stdout.printf("\n");

			try {
				return Process.spawn_async(null, args, null, SpawnFlags.SEARCH_PATH, null, null, null)? 0: 1;
			} catch(SpawnError se) {
				stderr.printf("Error spawning\n");
			}

			return 1;
		}// launch_any
	}// XMaeme class
}// XMaeme namespace
