using GLib;

namespace XMaeme {
	public class Gnuboy: GLib.Object {
		public const string	EXECUTABLE = "sdlgnuboy";
		public const string	YUV = "--yuv";
		public const string	SOUND = "--sound";
		public const string	NOSOUND = "--no-sound";
		public const string	SAMPLERATE = "--samplerate=11025";
		public const string	SCALE = "--scale=3";
		public const string	SOURCE = "--source";
		public const string	SSOURCE = "/etc/gnuboy.rc";
		public const string	FULLSCREEN = "--fullscreen";

		public static int launch(string romname, bool useSound) {
			string fullrom = XMaeme.getRomFullPath(romname, RomType.GBC);
			string[] argv = new string[] { EXECUTABLE, SOURCE, SSOURCE, FULLSCREEN, (useSound? SOUND: NOSOUND), SAMPLERATE, SCALE, ((null == fullrom)? romname: fullrom), null };

			return XMaeme.launch_any(argv);
		}// launch
	}// Gnuboy
}// XMaeme
