using GLib;

namespace XMaeme {
	public class Fceu : GLib.Object {
		public const string EXECUTABLE = "fceu";
		public const string SOUND	= "-sound";
		public const string FULLSCREEN	= "-fs";
		public const string XSCALE	= "-xres";
		public const string YSCALE	= "-yres";
		public const string FSKIP	= "-frameskip";
		public const string BPP		= "-bpp";
		public const string BPPFS	= "-bppfs";
		public const string NOTHROTTLE	= "-nothrottle";

		public static int launch(string romname, bool useSound, bool fullscreen, bool doubleSize, uint skipFrames) {
			string	fullrom = XMaeme.getRomFullPath(romname, RomType.NES),
				frames = skipFrames.to_string();
			string[] argv = new string[] { EXECUTABLE, NOTHROTTLE, "1", SOUND, (useSound? "1": "0"), FULLSCREEN, "1", XSCALE, "800", YSCALE, "480", FSKIP, frames, BPPFS, "8", ((null == fullrom)? romname: fullrom), null };

			Environment.set_variable("SDL_VIDEO_X11_WMCLASS", "fceu", true);

			return XMaeme.launch_any(argv);
		}// launch
	}// Fceu
}// XMaeme
