using GLib;
using Gtk;
using Glade;

public static void on_mame_launch_clicked(Button button, pointer user_data) {
	weak Glade.XML xml = XMaeme.XMaeme.GladeXml;
	weak ComboBox romlist = (ComboBox)xml.get_widget("mame_romlist");
	weak ToggleButton	sound = (ToggleButton)xml.get_widget("mame_sound"),
				rot = (ToggleButton)xml.get_widget("mame_rotate"),
				dbl = (ToggleButton)xml.get_widget("mame_double");
	
	int status = XMaeme.Xmame.launch(	romlist.get_active_text(),
						sound.get_active(),
						true,
						rot.get_active(),
						dbl.get_active() );

	if(0 < status){ XMaeme.show_information("Unable to load ROM"); }
	else if(0 > status){ XMaeme.show_information("Unable to launch emulator"); }
}// on_mame_launch_clicked

public static void on_nes_launch_clicked(Button button, pointer user_data) {
	weak Glade.XML xml = XMaeme.XMaeme.GladeXml;
	weak ComboBox romlist = (ComboBox)xml.get_widget("nes_romlist");
	uint frames = getNESFrameskip();
				
	int status = XMaeme.Fceu.launch(	romlist.get_active_text(),
						((ToggleButton)xml.get_widget("nes_sound")).get_active(),
						true,
						true,
						frames);
				
	
	if(0 < status){ XMaeme.show_information("Unable to load ROM"); }
	else if(0 > status){ XMaeme.show_information("Unable to launch emulator"); }
}// on_nes_launch_clicked

public static void on_gba_launch_clicked(Button button, pointer user_data) {
	weak Glade.XML xml = XMaeme.XMaeme.GladeXml;
	weak ComboBox romlist = (ComboBox)xml.get_widget("gba_romlist");
	uint frames = getGBAFrameskip();
				
	int status = XMaeme.VBA.launch(	romlist.get_active_text(),
						false,
						true,
						((ToggleButton)xml.get_widget("gba_double")).get_active(),
						frames);
				
	if(0 < status){ XMaeme.show_information("Unable to load ROM"); }
	else if(0 > status){ XMaeme.show_information("Unable to launch emulator"); }
}// on_gba_launch_clicked

public static void on_gbc_launch_clicked(Button button, pointer user_data) {
	weak Glade.XML xml = XMaeme.XMaeme.GladeXml;
	weak ComboBox romlist = (ComboBox)xml.get_widget("gbc_romlist");
				
	int status = XMaeme.Gnuboy.launch(	romlist.get_active_text(),
						((ToggleButton)xml.get_widget("gbc_sound")).get_active());			
	if(0 < status){ XMaeme.show_information("Unable to load ROM"); }
	else if(0 > status){ XMaeme.show_information("Unable to launch emulator"); }
}// on_gbc_launch_clicked

public static void on_ng_launch_clicked(Button button, pointer user_data) {
	weak Glade.XML xml = XMaeme.XMaeme.GladeXml;
				
	int status = XMaeme.Gngeo.launch(	((ComboBox)xml.get_widget("ng_romlist")).get_active_text(),
						((Entry)xml.get_widget("ng_bios")).get_text(),
						((ToggleButton)xml.get_widget("ng_sound")).get_active() );
				
	if(0 < status){ XMaeme.show_information("Unable to load ROM"); }
	else if(0 > status){ XMaeme.show_information("Unable to launch emulator"); }
}// on_ng_launch_clicked

public static void on_lynx_launch_clicked(Button button, pointer user_data) {
	weak Glade.XML xml = XMaeme.XMaeme.GladeXml;
	weak ComboBox romlist = (ComboBox)xml.get_widget("lynx_romlist");
				
	int status = XMaeme.Handy.launch(	romlist.get_active_text(),
						((ToggleButton)xml.get_widget("lynx_sound")).get_active());			
	if(0 < status){ XMaeme.show_information("Unable to load ROM"); }
	else if(0 > status){ XMaeme.show_information("Unable to launch emulator"); }
}// on_lynx_launch_clicked

public static void on_mame_browse_clicked(Button button, pointer user_data) {
	XMaeme.XMaeme.browse((int)XMaeme.RomType.MAME);
}// on_mame_browse_clicked

public static void on_nes_browse_clicked(Button button, pointer user_data) {
	XMaeme.XMaeme.browse((int)XMaeme.RomType.NES);
}// on_nes_browse_clicked

public static void on_gba_browse_clicked(Button button, pointer user_data) {
	XMaeme.XMaeme.browse((int)XMaeme.RomType.GBA);
}// on_gba_browse_clicked

public static void on_gbc_browse_clicked(Button button, pointer user_data) {
	XMaeme.XMaeme.browse((int)XMaeme.RomType.GBC);
}// on_gbc_browse_clicked

public static void on_ng_browse_clicked(Button button, pointer user_data) {
	XMaeme.XMaeme.browse((int)XMaeme.RomType.NEOGEO);
}// on_ng_browse_clicked

public static void on_lynx_browse_clicked(Button button, pointer user_data) {
	XMaeme.XMaeme.browse((int)XMaeme.RomType.LYNX);
}// on_lynx_browse_clicked

public static void on_nes_sound_toggled(ToggleButton button, pointer user_data) {
	bool checked = button.get_active();
	int frames = (int)getNESFrameskip();

	frames += (checked? 2: -2);
	if(frames < 0){ frames = 0; }
	else if(frames > 9){ frames = 9; }

	setNESFrameskip((uint)frames);
}// on_nes_sound_toggled

public static uint getNESFrameskip() {
	return (uint)XMaeme.get_spin_value("nes_frameskip");
}// getNESFrameskip

public static uint setNESFrameskip(uint frames) {
	XMaeme.set_spin_value("nes_frameskip", (int)frames);
	return frames;
}// setNESFrameskip

public static uint getGBAFrameskip() {
	return (uint)XMaeme.get_spin_value("gba_frameskip");
}// getGBAFrameskip

public static uint setGBAFrameskip(uint frames) {
	XMaeme.set_spin_value("gba_frameskip", (int)frames);
	return frames;
}// setGBAFrameskip

public static void on_ng_bios_browse_clicked(Button button, pointer user_data) {
	weak Glade.XML xml = XMaeme.XMaeme.GladeXml;
	weak Entry oldbios = (Entry)xml.get_widget("ng_bios");
	FileChooserDialog filedialog = new FileChooserDialog("Choose BIOS folder", (Window)xml.get_widget("mainwindow"), FileChooserAction.SELECT_FOLDER, STOCK_CANCEL, ResponseType.CANCEL, STOCK_OPEN, ResponseType.OK, null);

	if(FileUtils.test(oldbios.get_text(), FileTest.EXISTS)) {
		filedialog.set_current_folder(oldbios.get_text());
	}

	if(ResponseType.OK == filedialog.run()) {
		oldbios.set_text(filedialog.get_filename());
	}

	filedialog.destroy();
}// on_ng_bios_browse_clicked

public static bool key_press_cb(Widget widget, Gdk.EventKey ekey, pointer window) {
	return false;
}// key_press_cb
