#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>

#include <sys/types.h>
#include <sys/wait.h>

#include "util.h"
#include "xmame.h"


#define XMAEME_XMAME_EXE	"xmame"
#define XMAEME_NO_SOUND		"-nosnd"
#define XMAEME_FULLSCREEN	"-fullscreen"
#define XMAEME_ROR		"-ror"
#define XMAEME_SCALE		"-scale"


gint launch_xmame(const gchar *romname, gboolean use_sound, gboolean fullscreen, gboolean ror, gboolean scale){
	int	status = 0,
		pid = 0;
	char *fullrom = get_rom_full_path(romname,XMAEME_ROMTYPE_MAME);

	if(!fullrom){
		fullrom = g_strdup(romname);
	}//use base romname


	if((pid=fork())){
		waitpid(pid, &status, 0);
	}//parent
	else{
		int i = 2;
		char* args[8] = { XMAEME_XMAME_EXE, fullrom, NULL, NULL, NULL, NULL, NULL, NULL };

		if(!use_sound)
			args[i++] = XMAEME_NO_SOUND;
		//if(fullscreen)
		args[i++] = XMAEME_FULLSCREEN;
		if(ror)
			args[i++] = XMAEME_ROR;
		if(scale){
			args[i++] = XMAEME_SCALE;
			args[i++] = "2";
		}//if

 		{
			int j = 1;

			printf("Child: running ");
			for(j=0;j<8;++j){
				printf("%s ", args[j]);
			}//for
			printf("\n");
		}
		
		status=execvp(XMAEME_XMAME_EXE,args);
		if(status<0){
			fprintf(stderr,"Unable to run %s: %s\n",XMAEME_XMAME_EXE,strerror(errno));
		}//if an error occurred

		exit(0);
	}//child

	g_free(fullrom);

	return status;
}//launch_xmame

gchar*	xmame_get_rompath_from_xmamerc(const gchar *filename) {
	gchar	*contents = NULL,
		**cursor = NULL,
		*rompath = NULL,
		**lines = NULL;

	if(!g_file_get_contents(filename, &contents, NULL, NULL)) {
		return NULL;
	}// couldn't read file

	if(!(lines = g_strsplit(contents, "\n", 0))) {
		g_free(contents);
		return NULL;
	}// couldn't split into lines

	g_free(contents);

	for(cursor = lines; cursor; ++cursor) {
		if(strstr(*cursor, "rompath") == *cursor) {
			gchar *tmp = (gchar*)g_malloc(sizeof(gchar) * (strlen(*cursor) + 1));
			rompath = (gchar*)g_malloc(sizeof(gchar) * (strlen(*cursor) + 1));

			sscanf(*cursor, "%s%s", tmp, rompath);
			g_free(tmp);
			break;
		}// got rompath line
	}// for each line

	g_strfreev(lines);

	return rompath;
}// xmame_get_rompath_from_xmamerc

