#include <gtk/gtkmain.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "hildon-util.h"

HildonProgram *_program = NULL;
osso_context_t *_osso = NULL;

void
hildon_util_program_initialize (void)
{
	if (!_program) {
		g_set_application_name ("\0");
		_program = hildon_program_get_instance ();
		_osso = osso_initialize (PACKAGE_TARNAME, PACKAGE_VERSION, TRUE, NULL);
	}
}

void
hildon_util_program_deinitialize (void)
{
	if (_osso)
		osso_deinitialize (_osso);
}

GtkWidget *
hildon_util_window_new_and_add (void)
{
	GtkWidget *win;

	win = hildon_window_new ();
	hildon_util_add_window (HILDON_WINDOW (win));

	return win;
}

void
hildon_util_add_window (HildonWindow *win)
{
	hildon_program_add_window (_program, win);
}

void
hildon_util_remove_window (HildonWindow *win)
{
	hildon_program_remove_window (_program, win);
}

void
hildon_util_open_url (const char *url)
{
	if (_osso) {
   		osso_rpc_run_with_defaults (_osso,
			"osso_browser",
			"open_new_window",
			NULL,
			DBUS_TYPE_STRING,
			url,
			DBUS_TYPE_INVALID);
  	}
}

void
hildon_util_disable_autocaps (GtkEntry *entry)
{
	HildonGtkInputMode mode;

	mode =	hildon_gtk_entry_get_input_mode (entry);
	mode &= ~HILDON_GTK_INPUT_MODE_AUTOCAP;
	hildon_gtk_entry_set_input_mode (entry, mode);

}

static void
tap_and_hold_simulate_click (GtkWidget *w, gint button)
{
	GdkEvent *press;
	GdkEvent *release;

	press = g_object_get_data (G_OBJECT (w), "press");

	if (press) {
		/* Generate a release event for button 1 */
		release = gdk_event_copy (press);
		release->button.type = GDK_BUTTON_RELEASE;
		release->button.state = GDK_BUTTON1_MASK;
		/* Make the press event right/middle click */
		press->button.button = button;
		/* Release button 1 */
		gtk_main_do_event (release);
		/* Simulate click */
		gtk_main_do_event (press);

		/* Free the release event - the press one is
		 * freed in tap_and_hold_button_press_filter()
		 */
		gdk_event_free (release);
	}
}

gboolean
tap_and_hold_button_press_filter (GtkWidget *w, GdkEventButton *e)
{
	GdkEvent *press;

	if (e->type == GDK_BUTTON_PRESS && e->button == 1) {
		/* Store button 1 event, so we don't need
		 * to find the pointer coordinates
		 * later
		 */
		press = g_object_get_data (G_OBJECT (w), "press");
		/* Free the previous stored one */
		if (press)
			gdk_event_free (press);
		press = gdk_event_copy ((GdkEvent*) e);
		g_object_set_data (G_OBJECT (w), "press", press);
	}

	return FALSE;
}

void
tap_and_hold_right_click_cb (GtkWidget *w, gpointer data)
{
	tap_and_hold_simulate_click (w, 3);
}

