/*
  WifiInfo - Show current Wifi sttaus
  Copyright (C) 2008  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "Status.h"

Status::Status()
{
  ClearStatus();

  statusChangedAction=new Lum::Model::Action();
  networksChangedAction=new Lum::Model::Action();
}

Status::~Status()
{
  // no code
}

void Status::ClearStatus()
{
  typeName.clear();
  type=typeNone;
  essid.clear();
  bitrate=0;
  quality=-1;
  signal=-1;
  noise=-1;
  accesspoint.clear();
  mac.clear();
  ip.clear();
}

int Status::GetQualityFromSignalNoiseDbm(int signal, int noise)
{
  int quality=signal-noise;

  if (quality<0) {
    return 0;
  }
  if (quality>=0 && quality<40) {
    return 5*quality/2;
  }
  else {
    return 100;
  }
}

bool Status::UpdateStatus()
{
  return false;
}

bool Status::UpdateNetworks()
{
  return false;
}
