#ifndef IMAGE_H
#define IMAGE_H

/*
  This file is part of "WhoAmI" - A "Guess whats on the photo" riddle game.
  Copyright (C) 2007  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <Lum/Images/Image.h>

class Image
{
private:
  std::string           author;
  std::string           title;
  std::string           description;
  std::string           imageLink;
  Lum::Images::ImageRef image;
  bool                  shown;

public:
  Image(const std::string& author,
        const std::string& title,
        const std::string& description,
        const std::string& imageLink);

  void SetImage(Lum::Images::Image* image);
  void SetShown();

  std::string GetAuthor() const;
  std::string GetTitle() const;
  std::string GetDescription() const;
  std::string GetImageLink() const;
  bool HasImage() const;
  Lum::Images::Image* GetImage() const;
  bool HasBeenShown() const;
};

#endif

