/* maemo vpnc-gui
 * 
 * Copyright (c) 2007 Michael "ScriptKiller" Arndt
 * http://scriptkiller.de/
 * <scriptkiller@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 */

/* IMPORTS */
#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <pwd.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <dirent.h>
#include <glib.h>

#include "profile.h"
#include "profiles_launcher.h"
#include "profiles_launcher_vpnc.h"

/* (local) VARIABLES */
static void (*event_cb)(struct profile *, gint event, gpointer data)=NULL;

/* LOCAL FUNCTIONS */
static void profiles_launcher_event_cb(struct profile *p,
		gint event,
		gpointer data) {
	/* just pass it unchanged ... */
	if(event_cb!=NULL)
		event_cb(p, event, data);
}

/* EXPORTS */

/**
 * Initialize profiles_launcher and all sub-launchers.
 * Must be called before any other function.
 */
void profiles_launcher_init() {

	/* for each sub-launcher, init it and set callback function */
	profiles_launcher_vpnc_init();
	profiles_launcher_vpnc_set_event_callback(profiles_launcher_event_cb);
}

/**
 * Set the callback function for connection-event-notification.
 * @param callback the function-pointer
 */
void profiles_launcher_set_event_callback(void (*callback)(struct profile *, gint event, gpointer data)) {
	event_cb=callback;
}

/**
 * Connect to specified profile.
 * @param p the profile
 */
void profiles_launcher_connect(struct profile *p) {
	if(p->type == PROFILE_TYPE_VPNC) {
		profiles_launcher_vpnc_connect(p);
	}
	else {
		printf("Implement profile type %d in %s:%d!\n", p->type, __FILE__, __LINE__);
	}
}

/**
 * Disconnect specified profile.
 * @param p the profile
 */
void profiles_launcher_disconnect(struct profile *p) {
	if(p->type == PROFILE_TYPE_VPNC) {
		profiles_launcher_vpnc_disconnect(p);
	}
	else {
		printf("Implement profile type %d in %s:%d!\n", p->type, __FILE__, __LINE__);
	}
}

/**
 * Feed password to vpnc client.
 * @param p profile to which it should be feeded
 * @param pw pointer to the password, no reference is kept
 */
void profiles_launcher_feed_password(struct profile *p, gchar *pw) {
	if(p->type == PROFILE_TYPE_VPNC) {
		profiles_launcher_vpnc_feed_password(pw);
	}
	else {
		printf("Implement profile type %d in %s:%d!\n", p->type, __FILE__, __LINE__);
	}
}
