/* maemo vpnc-gui
 * 
 * Copyright (c) 2007 Michael "ScriptKiller" Arndt
 * http://scriptkiller.de/
 * <scriptkiller@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 */

/* BEGIN IMPORTS */

#include <glib.h>

#include "profile.h"

/* BEGIN EXPORTS */

/**
 * Allocate memory for a new profile, aborts program if allocation
 * fails.
 * 
 * @return pointer to allocated memory
 */
struct profile *profile_alloc() {
	return g_malloc(sizeof(struct profile));
}

/**
 * Free memory of specified profile, also tries to free
 * all members of struct EXCEPT config-data!
 * 
 * @param p the profile
 */
void profile_free(struct profile *p) {
	if(p->name)
		g_free(p->name);
	g_free(p);
}
