/* maemo vpnc-gui
 * 
 * Copyright (c) 2007 Michael "ScriptKiller" Arndt
 * http://scriptkiller.de/
 * <scriptkiller@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 */

#include "hildon.h"

#include <gtk/gtk.h>
#include <gtk/gtktext.h>


#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <pwd.h>
#include <errno.h>

/* show the save-buffer dialog */
void save_buffer_show_dialog(GtkWindow *main_window, GtkWidget *buffer) {

  GtkDialog *dialog;
  
  dialog=
    hildon_file_chooser_dialog_new(main_window,
				   GTK_FILE_CHOOSER_ACTION_SAVE);
  
  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK) {

    gchar *filename = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(dialog));

    if(filename!=NULL) {

      FILE *f = fopen (filename, "w");
      gchar *buffer_content = gtk_editable_get_chars(GTK_EDITABLE(buffer),
						    0, -1);

      fwrite(buffer_content, sizeof(gchar),
	     gtk_text_get_length(buffer), f);

      fclose (f);

    }

  }
  gtk_widget_destroy(dialog);
}
