/* maemo vpnc-gui
 * 
 * Copyright (c) 2007 Michael "ScriptKiller" Arndt
 * http://scriptkiller.de/
 * <scriptkiller@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 */

#include "hildon.h"

#include <gtk/gtk.h>

#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <pwd.h>
#include <errno.h>


#include "config_data.h"

#define CONFIG_DIR "/.vpnc-gui/"
#define CONFIG_FILE "/vpnc.conf"

enum {
  CONF_IMPORT_PCF,
  CONF_SAVE,
  CONF_CANCEL
};


/* globals */
GtkWidget *xauth_user;
GtkWidget *xauth_pw;

GtkWidget *ipsec_gw;
GtkWidget *ipsec_id;
GtkWidget *ipsec_secret;

GtkWidget *domain;

/* path of config-file */
char *config_path;

void configuration_init() {

  struct passwd *pw=getpwuid(getuid());
  
  if(pw==NULL) {
    perror("getpwuid");
    return;
  }

  config_path=g_malloc(strlen(pw->pw_dir)+
		       strlen(CONFIG_DIR CONFIG_FILE)+
		       1);
  
  strcpy(config_path, pw->pw_dir);
  strcpy(config_path+strlen(pw->pw_dir), CONFIG_DIR);
  
  /* try to create dir */
  if(mkdir(config_path, 0700) == -1 && errno != EEXIST) {
    perror("mkdir");
    return;
  }

  
  strcpy(config_path+strlen(pw->pw_dir)+strlen(CONFIG_DIR), CONFIG_FILE);

#ifdef DEBUG
  printf("Config-path: %s\n", config_path);
#endif
  
}


/* save configuration from GUI to disk */
void configuration_save() {

 

  FILE *fp=fopen(config_path, "w");
  if(fp==NULL) {
    perror("fopen failed");
    return;
  }


  fprintf(fp, "# Generated by maemo vpnc-gui\n");
  fprintf(fp, "# Michael 'ScriptKiller' Arndt <scriptkiller@gmx.de>\n");
  fprintf(fp, "# DON'T EDIT BY HAND (unless u really know what u're doing)\n\n");



  fprintf(fp, "IPSec gateway %s\n",
	  gtk_entry_get_text(GTK_ENTRY(ipsec_gw)));
  fprintf(fp, "IPSec ID %s\n",
	  gtk_entry_get_text(GTK_ENTRY(ipsec_id)));
  fprintf(fp, "IPSec Secret %s\n",
	  gtk_entry_get_text(GTK_ENTRY(ipsec_secret)));
	  
  fprintf(fp, "Xauth username %s\n",
	  gtk_entry_get_text(GTK_ENTRY(xauth_user)));
  fprintf(fp, "Xauth password %s\n",
	  gtk_entry_get_text(GTK_ENTRY(xauth_pw)));

  fprintf(fp, "Domain %s\n",
	  gtk_entry_get_text(GTK_ENTRY(domain)));

  fclose(fp);

#ifdef DEBUG
  puts("Config written");
#endif

}

/* read configuration from disk to GUI */
void configuration_read() {

  FILE *fp=fopen(config_path, "r");
  if(fp==NULL) {
    perror("fopen failed");
    return;
  }

  
  char *line = NULL;
  size_t line_length = 0;


  for(;;) {
    ssize_t llen;
    int i;
    
    llen = getline(&line, &line_length, fp);
    if (llen == -1 && feof(fp))
      break;
    if (llen == -1) {
      perror("getline failed");
      break;
    }

    if(line[0]=='#')
      continue;

    /* strip \n */
    line[llen-1]='\0';

#ifdef DEBUG
    printf("line: '%s'\n", line);
#endif

    if(strstr(line, "IPSec gateway ")==line) {
      gtk_entry_set_text(GTK_ENTRY(ipsec_gw), line+sizeof("IPSec gateway"));
    }
    else if(strstr(line, "IPSec ID ")==line) {
      gtk_entry_set_text(GTK_ENTRY(ipsec_id), line+sizeof("IPSec ID"));
    }
    else if(strstr(line, "IPSec Secret ")==line) {
      gtk_entry_set_text(GTK_ENTRY(ipsec_secret), line+sizeof("IPSec Secret"));
    }
    else if(strstr(line, "Xauth username ")==line) {
      gtk_entry_set_text(GTK_ENTRY(xauth_user), line+sizeof("Xauth username"));
    }
    else if(strstr(line, "Xauth password ")==line) {
      gtk_entry_set_text(GTK_ENTRY(xauth_pw), line+sizeof("Xauth password"));
    }
    else if(strstr(line, "Domain ")==line) {
      gtk_entry_set_text(GTK_ENTRY(domain), line+sizeof("Domain"));
    }



  }

  if(line!=NULL)
    free(line);


}


/* called by pcf_import when import is done */
void configuration_pcf_import_cb(config_data *data) {

  if(data->xauth_user) {
    gtk_entry_set_text(GTK_ENTRY(xauth_user), data->xauth_user);
    free(data->xauth_user);
  }
  if(data->xauth_pw) {
    gtk_entry_set_text(GTK_ENTRY(xauth_pw), data->xauth_pw);
    free(data->xauth_pw);
  }
  if(data->ipsec_gw) {
    gtk_entry_set_text(GTK_ENTRY(ipsec_gw), data->ipsec_gw);
    free(data->ipsec_gw);
  }
  if(data->ipsec_id) {
    gtk_entry_set_text(GTK_ENTRY(ipsec_id), data->ipsec_id);
    free(data->ipsec_id);
  }
  if(data->ipsec_secret) {
    gtk_entry_set_text(GTK_ENTRY(ipsec_secret), data->ipsec_secret);
    free(data->ipsec_secret);
  }
  if(data->domain) {
    gtk_entry_set_text(GTK_ENTRY(domain), data->domain);
    free(data->domain);
  }

}

void configuration_dialog_pcf_file_open(char *filename) {

#ifdef DEBUG
  printf("Filename: %s\n", filename);
#endif

  pcf_import_file(filename,
		  configuration_pcf_import_cb);

}

void configuration_dialog_response_cb(GtkDialog * window,
				      gint response,
				      gpointer data)
{
  GtkTreeSelection *selection = NULL;
  GtkTreeModel *model = NULL;
  GtkTreeIter iter;

  GtkWidget *dialog;

  switch (response) {

  case CONF_IMPORT_PCF:

    dialog=
      hildon_file_chooser_dialog_new(GTK_WINDOW(window),
				     GTK_FILE_CHOOSER_ACTION_OPEN);

    if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK) {
      configuration_dialog_pcf_file_open(gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(dialog)));
    }
    gtk_widget_destroy(dialog);



    break;

  case CONF_SAVE:

    configuration_save();
    /* fall trough to next ... */

  case CONF_CANCEL:
    gtk_widget_destroy(GTK_WIDGET(window));

  }

}

void configuration_dialog_show(void) {

  GtkWidget *table;
  GtkWidget *window;





  window = gtk_dialog_new_with_buttons("Configuration",
				       NULL,
				       GTK_DIALOG_NO_SEPARATOR,
				       "Import PCF",
				       CONF_IMPORT_PCF,
				       "Save",
				       CONF_SAVE,
				       "Cancel",
				       CONF_CANCEL,
				       NULL);

  /* create entries */
  xauth_user=gtk_entry_new();
  xauth_pw=gtk_entry_new();
  gtk_entry_set_visibility(GTK_ENTRY(xauth_pw), FALSE);
  ipsec_gw=gtk_entry_new();
  ipsec_id=gtk_entry_new();
  ipsec_secret=gtk_entry_new();
  gtk_entry_set_visibility(GTK_ENTRY(ipsec_secret), FALSE);
  domain=gtk_entry_new();


  table=gtk_table_new(10,
                      2,
                      FALSE);

  
  gtk_table_attach_defaults(GTK_TABLE(table),
			    gtk_label_new("Gateway"),
			    0, 1, 0, 1);

  gtk_table_attach_defaults(GTK_TABLE(table),
			    ipsec_gw,
			    1, 2, 0, 1);

  gtk_table_attach_defaults(GTK_TABLE(table),
			    gtk_label_new("Group-Name"),
			    0, 1, 1, 2);

  gtk_table_attach_defaults(GTK_TABLE(table),
			    ipsec_id,
			    1, 2, 1, 2);


  gtk_table_attach_defaults(GTK_TABLE(table),
			    gtk_label_new("Group-PW"),
			    0, 1, 2, 3);

  gtk_table_attach_defaults(GTK_TABLE(table),
			    ipsec_secret,
			    1, 2, 2, 3);


  gtk_table_attach_defaults(GTK_TABLE(table),
			    gtk_label_new("Username"),
			    0, 1, 3, 4);

  gtk_table_attach_defaults(GTK_TABLE(table),
			    xauth_user,
			    1, 2, 3, 4);


  gtk_table_attach_defaults(GTK_TABLE(table),
			    gtk_label_new("Password"),
			    0, 1, 4, 5);

  gtk_table_attach_defaults(GTK_TABLE(table),
			    xauth_pw,
			    1, 2, 4, 5);



  gtk_table_attach_defaults(GTK_TABLE(table),
			    gtk_label_new("Domain"),
			    0, 1, 5, 6);

  gtk_table_attach_defaults(GTK_TABLE(table),
			    domain,
			    1, 2, 5, 6);


  gtk_box_pack_end(GTK_BOX(GTK_DIALOG(window)->vbox), table, TRUE, TRUE, 0);

  
  
  g_signal_connect(G_OBJECT(window),
                   "response",
		   G_CALLBACK(configuration_dialog_response_cb), NULL);
  

  /* read config */
  configuration_read();


  gtk_widget_show_all(window);


}
