#!/usr/bin/env python
#
# 
#

import sys
import optparse
import re
import string
import os
import time
import gtk
import commands
import hildon

from threading import Thread
		
# Global constants



os.environ["SDL_VIDEO_X11_WMCLASS"]="usbcontrol"





class usbcontrol(hildon.Program):
	def __init__(self):
		hildon.Program.__init__(self)
		self.saveOn=True
		self.window = hildon.Window()
		self.window.connect("destroy", gtk.main_quit)  
		self.add_window(self.window)
		
		self.otg_button = gtk.Button("OTG")
		self.otg_button.connect("clicked", self.setUSBOTGMode)
		
		self.peripheral_button = gtk.Button("Peripheral")
		self.peripheral_button.connect("clicked", self.setUSBPeripheralMode)
		
		self.host_button = gtk.Button("Host")
		self.host_button.connect("clicked", self.setUSBHostMode)
		
		self.refresh_button = gtk.Button("Refresh")
		self.refresh_button.connect("clicked", self.updateUSBState)
		
		self.textBuff = gtk.TextBuffer(None)
		self.textBuff.set_text(commands.getoutput("lsusb"))
		self.textArea = gtk.TextView(self.textBuff)

		vbox = gtk.VBox(False, 0)
		self.window.add(vbox)
		vbox.show()
		
		hbox = gtk.HBox(False, 0)		
		hbox2 = gtk.HBox(False, 0)		
		hbox3 = gtk.HBox(False, 0)		
		
		hbox3.add(self.textArea)
		self.textArea.show()

		self.labelUSBState = gtk.Label("USB CONTROLLER MODE: "+self.getUSBState())
		hbox2.pack_start(self.labelUSBState, True, False, 0)
		hbox2.pack_start(self.refresh_button, False, True, 0)
				
		hbox.pack_start(self.otg_button, True, True, 0)
		hbox.pack_start(self.peripheral_button, True, True, 0)
		hbox.pack_start(self.host_button, True, True, 0)		
		vbox.pack_start(hbox2, False, True, 0)
		vbox.pack_start(hbox3, True, True, 0)
		vbox.pack_start(hbox, False, True, 0)
		hbox.show()
		hbox2.show()
		hbox3.show()
		self.otg_button.show()
		self.peripheral_button.show()
		self.host_button.show()
	
	
	def updateUSBStateLabel(self):
		self.labelUSBState.set_text("USB CONTROLLER MODE: "+self.getUSBState())
		self.textBuff.set_text(commands.getoutput("lsusb"))
		while gtk.events_pending():
			gtk.main_iteration()				
		
	def updateUSBState(self, widget):		
		self.updateUSBStateLabel()
		
	
	def getUSBState(self):
		try:
		    f = open("/sys/devices/platform/musb_hdrc/mode", 'r' )
		    filecontent = f.readline()            
		    f.close()
		    return filecontent
		except:
		    print "CANNOT OPEN THE FILE"
		    return "UNKNOWN"

			
	def setUSBHostMode(self, widget):		
		command = 'echo host > /sys/devices/platform/musb_hdrc/mode'		
		os.system(command)
		self.updateUSBStateLabel()
			
	def setUSBPeripheralMode(self, widget):		
		command = 'echo peripheral > /sys/devices/platform/musb_hdrc/mode'		
		os.system(command)
		self.updateUSBStateLabel()
			
	def setUSBOTGMode(self, widget):		
		command = 'echo otg > /sys/devices/platform/musb_hdrc/mode'		
		os.system(command)
		self.updateUSBStateLabel()
		
	def run(self):     
		self.window.show_all()
		gtk.main() 

if __name__ == "__main__":  
	app = usbcontrol() 
	app.run()         
