/*
* This file is part of TuxPuck
*
* Copyright (C) 2005 INdT - Instituto Nokia de Tecnologia
* http://www.indt.org/maemo
*
* This software is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public License
* as published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA
*
*/

#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <startup_plugin.h>
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>

#define SETTINGS_OPPONENT "/apps/osso/tuxpuck/opponent"
#define SETTINGS_SOUND    "/apps/osso/tuxpuck/enable_sound"

#define ARCANA          1
#define TUX             0
#define SOUND           2

static GtkWidget *load_plugin               (void);
static void       unload_plugin             (void);
static void       write_config              (void);
static GtkWidget **load_menu                (guint *);
static void       update_menu               (void);
static void       opponent_callback         (GtkWidget   *widget,
                                             gpointer     data);
static void       sound_callback            (GtkWidget   *widget,
                                             gpointer     data);
static void       plugin_callback           (GtkWidget   *menu_item,
                                             gpointer     data);                                             

GConfClient *gcc = NULL;
GtkWidget *opponent_box;
GtkWidget *sound_check;
GtkWidget *arcana_item;
GtkWidget *tux_item;
GtkWidget *settings_item;
GtkWidget *opponent_menu;
GtkWidget * opponent_item;
GtkWidget *sound_item;
GtkWidget *settings_menu;
static GameStartupInfo gs;
GtkWidget *menu_items[2];
static int changed = FALSE;
GSList * group = NULL;

static StartupPluginInfo plugin_info = {
  load_plugin,
  unload_plugin,
  write_config,
  load_menu,
  update_menu,
  NULL
};

STARTUP_INIT_PLUGIN(plugin_info, gs, TRUE, TRUE)


static GtkWidget *
load_plugin (void)
{
  int sound, opponent;
  GtkWidget *game_hbox;
  GtkWidget *opponent_hbox;
  GtkWidget *opponent_box_align;
  GtkWidget *opponent_label;
  GtkWidget *sound_hbox;
  GtkWidget *sound_label;

  g_type_init();
  gcc = gconf_client_get_default();
  opponent = gconf_client_get_int(gcc, SETTINGS_OPPONENT, NULL);
  sound = gconf_client_get_bool(gcc, SETTINGS_SOUND, NULL);

  game_hbox = gtk_hbox_new (TRUE, 0);
  g_assert (game_hbox);

  opponent_hbox = gtk_hbox_new (FALSE, 8);

  opponent_box = gtk_combo_box_new_text ();
  g_assert (opponent_box);

  gtk_combo_box_append_text (GTK_COMBO_BOX (opponent_box),
    "Tux");

  gtk_combo_box_append_text (GTK_COMBO_BOX (opponent_box),
    "Arcana");

  gtk_combo_box_set_active (GTK_COMBO_BOX (opponent_box), opponent);

  opponent_box_align = gtk_alignment_new (0.5, 0.5, 1, 0);
  gtk_widget_set_size_request (opponent_box, 200, 30);
  gtk_container_add (GTK_CONTAINER (opponent_box_align), opponent_box);
  gtk_box_pack_end (GTK_BOX (opponent_hbox),
    opponent_box_align, FALSE, FALSE, 0);

  opponent_label = gtk_label_new ("Opponent");
  g_assert(opponent_label);

  gtk_box_pack_end (GTK_BOX (opponent_hbox),
    opponent_label, FALSE, FALSE, 0);

  gtk_box_pack_start (GTK_BOX (game_hbox),
    opponent_hbox, FALSE, FALSE, 2);

  sound_hbox = gtk_hbox_new (FALSE, 8);
  
  sound_label = gtk_label_new ("Sound effects");
  g_assert (sound_label);

  gtk_box_pack_start (GTK_BOX (sound_hbox),
    sound_label, FALSE, FALSE, 0);

  sound_check = gtk_check_button_new ();
  g_assert (sound_check);

  gtk_box_pack_start (GTK_BOX (sound_hbox),
    sound_check, FALSE, FALSE, 0);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(sound_check), sound);

  gtk_box_pack_start (GTK_BOX (game_hbox),
    sound_hbox, FALSE, FALSE, 2);
    
  g_signal_connect (G_OBJECT(opponent_box), "changed",
      G_CALLBACK(opponent_callback), NULL);
 
  g_signal_connect (G_OBJECT(sound_check), "clicked",
      G_CALLBACK(sound_callback), NULL);    

  return game_hbox;
}

static void
unload_plugin (void)
{
  free(gcc);
  free(opponent_box);
  free(sound_check);
}

static void 
write_config (void)
{
  gconf_client_set_int(gcc, SETTINGS_OPPONENT,
	gtk_combo_box_get_active(GTK_COMBO_BOX(opponent_box)), NULL);
  gconf_client_set_bool(gcc, SETTINGS_SOUND, 
	gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(sound_check)), NULL);
}

static GtkWidget **
load_menu (guint *nitems)
{
    *nitems = 1;
    settings_item = gtk_menu_item_new_with_label ("Settings");
    settings_menu = gtk_menu_new ();    
    menu_items[0] = settings_item;
    
    gtk_menu_item_set_submenu (GTK_MENU_ITEM (settings_item), settings_menu);

    //opponent settings
    opponent_menu = gtk_menu_new ();
    opponent_item = gtk_menu_item_new_with_label ("Opponent");
    gtk_menu_item_set_submenu (GTK_MENU_ITEM (opponent_item), opponent_menu);
    gtk_menu_append (GTK_MENU (settings_menu), opponent_item);

    tux_item = gtk_radio_menu_item_new_with_label (group, "Tux");
    gtk_menu_append (GTK_MENU (opponent_menu), tux_item);

    group = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(tux_item));
 
    arcana_item = gtk_radio_menu_item_new_with_label (group, "Arcana");
    gtk_menu_append (GTK_MENU (opponent_menu), arcana_item);

    g_signal_connect (G_OBJECT (arcana_item), "toggled",
                            G_CALLBACK (plugin_callback),
                            (gpointer) ARCANA);
    g_signal_connect (G_OBJECT (tux_item), "toggled",
                            G_CALLBACK (plugin_callback),
                            (gpointer) TUX);
  
    gtk_menu_append (GTK_MENU (settings_menu), gtk_menu_item_new());

    //sound settings
    sound_item = gtk_check_menu_item_new_with_label(
                 "Sound");
    gtk_menu_append (GTK_MENU (settings_menu), sound_item);
    g_signal_connect (G_OBJECT (sound_item),
                      "toggled",
                      G_CALLBACK (plugin_callback),
                      (gpointer) SOUND);
    gtk_check_menu_item_set_state (GTK_CHECK_MENU_ITEM(sound_item),
	  	  gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (sound_check)));

    return menu_items;    
}

static void
plugin_callback (GtkWidget *menu_item,
                 gpointer  data)
{

  switch ((int) data) {
    case ARCANA:
    case TUX:
        if (!changed) {
        changed = TRUE;
        gtk_combo_box_set_active (GTK_COMBO_BOX (opponent_box), (int) data);
      }
      break;
     case SOUND:
       if (!changed) {
          changed = TRUE;
          gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (sound_check), 
                                        gtk_check_menu_item_get_active (
                                          GTK_CHECK_MENU_ITEM(sound_item)));
       }
       break;
  }
  changed = FALSE;
}


static void 
sound_callback (GtkWidget *widget, 
                gpointer   data)
{
  if (!changed) {
    changed = TRUE;
    gtk_check_menu_item_set_state (GTK_CHECK_MENU_ITEM(sound_item), gtk_toggle_button_get_active(
                                                 GTK_TOGGLE_BUTTON (widget)));
  }
  changed = FALSE;           
}

static void 
opponent_callback (GtkWidget *widget, 
                   gpointer   data)
{
  if (!changed) {
    changed = TRUE;
    gint active = gtk_combo_box_get_active (GTK_COMBO_BOX (widget));

    if (active) {
        gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(arcana_item), TRUE);
    } else {
        gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(tux_item), TRUE);
    }
  }
  changed = FALSE;
}

static void
update_menu (void)
{
  opponent_callback (opponent_box, NULL);
  sound_callback (sound_check, NULL);
}


